/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SUR_P09_FACPSHPDCPSHFACPDCNTE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: FAC (FAC - facility segment) <b> </b></li>
                 * <li>2: SUR_P09_PSHPDC (a Group object) <b> repeating</b></li>
                 * <li>3: PSH (PSH - product summary header segment) <b> </b></li>
                 * <li>4: SUR_P09_FACPDCNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class SUR_P09_FACPSHPDCPSHFACPDCNTE extends AbstractGroup {

    /** 
     * Creates a new SUR_P09_FACPSHPDCPSHFACPDCNTE group
     */
    public SUR_P09_FACPSHPDCPSHFACPDCNTE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(FAC.class, true, false);
                          this.add(SUR_P09_PSHPDC.class, true, true);
                          this.add(PSH.class, true, false);
                          this.add(SUR_P09_FACPDCNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SUR_P09_FACPSHPDCPSHFACPDCNTE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * FAC (FAC - facility segment) - creates it if necessary
     */
    public FAC getFAC() { 
       FAC ret = null;
       try {
          ret = (FAC)this.get("FAC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PSHPDC (a Group object) - creates it if necessary
     */
    public SUR_P09_PSHPDC getPSHPDC() { 
       SUR_P09_PSHPDC ret = null;
       try {
          ret = (SUR_P09_PSHPDC)this.get("PSHPDC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PSHPDC (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SUR_P09_PSHPDC getPSHPDC(int rep) { 
       SUR_P09_PSHPDC ret = null;
       try {
          ret = (SUR_P09_PSHPDC)this.get("PSHPDC", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PSHPDC 
     */ 
    public int getPSHPDCReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PSHPDC").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PSHPDC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPSHPDC(SUR_P09_PSHPDC structure, int rep) throws HL7Exception { 
       super.insertRepetition("PSHPDC", structure, rep);
    }


    /**
     * Inserts a specific repetition of PSHPDC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SUR_P09_PSHPDC insertPSHPDC(int rep) throws HL7Exception { 
       return (SUR_P09_PSHPDC)super.insertRepetition("PSHPDC", rep);
    }


    /**
     * Removes a specific repetition of PSHPDC (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SUR_P09_PSHPDC removePSHPDC(int rep) throws HL7Exception { 
       return (SUR_P09_PSHPDC)super.removeRepetition("PSHPDC", rep);
    }



    /**
     * Returns
     * PSH (PSH - product summary header segment) - creates it if necessary
     */
    public PSH getPSH() { 
       PSH ret = null;
       try {
          ret = (PSH)this.get("PSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * FACPDCNTE (a Group object) - creates it if necessary
     */
    public SUR_P09_FACPDCNTE getFACPDCNTE() { 
       SUR_P09_FACPDCNTE ret = null;
       try {
          ret = (SUR_P09_FACPDCNTE)this.get("FACPDCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * FACPDCNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SUR_P09_FACPDCNTE getFACPDCNTE(int rep) { 
       SUR_P09_FACPDCNTE ret = null;
       try {
          ret = (SUR_P09_FACPDCNTE)this.get("FACPDCNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of FACPDCNTE 
     */ 
    public int getFACPDCNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("FACPDCNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of FACPDCNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertFACPDCNTE(SUR_P09_FACPDCNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("FACPDCNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of FACPDCNTE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SUR_P09_FACPDCNTE insertFACPDCNTE(int rep) throws HL7Exception { 
       return (SUR_P09_FACPDCNTE)super.insertRepetition("FACPDCNTE", rep);
    }


    /**
     * Removes a specific repetition of FACPDCNTE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SUR_P09_FACPDCNTE removeFACPDCNTE(int rep) throws HL7Exception { 
       return (SUR_P09_FACPDCNTE)super.removeRepetition("FACPDCNTE", rep);
    }



}

