/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ADT_A44 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: EVN (EVN - event type segment) <b> </b></li>
                 * <li>3: ADT_A44_PIDPD1MRG (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ADT_A44 extends AbstractMessage  {

    /**
     * Creates a new ADT_A44 message with DefaultModelClassFactory. 
     */ 
    public ADT_A44() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ADT_A44 message with custom ModelClassFactory.
     */
    public ADT_A44(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(ADT_A44_PIDPD1MRG.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADT_A44 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * EVN (EVN - event type segment) - creates it if necessary
     */
    public EVN getEVN() { 
       EVN ret = null;
       try {
          ret = (EVN)this.get("EVN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDPD1MRG (a Group object) - creates it if necessary
     */
    public ADT_A44_PIDPD1MRG getPIDPD1MRG() { 
       ADT_A44_PIDPD1MRG ret = null;
       try {
          ret = (ADT_A44_PIDPD1MRG)this.get("PIDPD1MRG");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPD1MRG (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ADT_A44_PIDPD1MRG getPIDPD1MRG(int rep) { 
       ADT_A44_PIDPD1MRG ret = null;
       try {
          ret = (ADT_A44_PIDPD1MRG)this.get("PIDPD1MRG", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPD1MRG 
     */ 
    public int getPIDPD1MRGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPD1MRG").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPD1MRG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDPD1MRG(ADT_A44_PIDPD1MRG structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDPD1MRG", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPD1MRG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ADT_A44_PIDPD1MRG insertPIDPD1MRG(int rep) throws HL7Exception { 
       return (ADT_A44_PIDPD1MRG)super.insertRepetition("PIDPD1MRG", rep);
    }


    /**
     * Removes a specific repetition of PIDPD1MRG (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ADT_A44_PIDPD1MRG removePIDPD1MRG(int rep) throws HL7Exception { 
       return (ADT_A44_PIDPD1MRG)super.removeRepetition("PIDPD1MRG", rep);
    }



}

