/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ADT_A45 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: EVN (EVN - event type segment) <b> </b></li>
                 * <li>3: PID (PID - patient identification segment) <b> </b></li>
                 * <li>4: PD1 (PD1 - patient additional demographic segment) <b>optional </b></li>
                 * <li>5: ADT_A45_MRGPV1 (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ADT_A45 extends AbstractMessage  {

    /**
     * Creates a new ADT_A45 message with DefaultModelClassFactory. 
     */ 
    public ADT_A45() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ADT_A45 message with custom ModelClassFactory.
     */
    public ADT_A45(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PD1.class, false, false);
                          this.add(ADT_A45_MRGPV1.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADT_A45 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * EVN (EVN - event type segment) - creates it if necessary
     */
    public EVN getEVN() { 
       EVN ret = null;
       try {
          ret = (EVN)this.get("EVN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (PID - patient identification segment) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PD1 (PD1 - patient additional demographic segment) - creates it if necessary
     */
    public PD1 getPD1() { 
       PD1 ret = null;
       try {
          ret = (PD1)this.get("PD1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MRGPV1 (a Group object) - creates it if necessary
     */
    public ADT_A45_MRGPV1 getMRGPV1() { 
       ADT_A45_MRGPV1 ret = null;
       try {
          ret = (ADT_A45_MRGPV1)this.get("MRGPV1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MRGPV1 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ADT_A45_MRGPV1 getMRGPV1(int rep) { 
       ADT_A45_MRGPV1 ret = null;
       try {
          ret = (ADT_A45_MRGPV1)this.get("MRGPV1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MRGPV1 
     */ 
    public int getMRGPV1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MRGPV1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MRGPV1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMRGPV1(ADT_A45_MRGPV1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MRGPV1", structure, rep);
    }


    /**
     * Inserts a specific repetition of MRGPV1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ADT_A45_MRGPV1 insertMRGPV1(int rep) throws HL7Exception { 
       return (ADT_A45_MRGPV1)super.insertRepetition("MRGPV1", rep);
    }


    /**
     * Removes a specific repetition of MRGPV1 (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ADT_A45_MRGPV1 removeMRGPV1(int rep) throws HL7Exception { 
       return (ADT_A45_MRGPV1)super.removeRepetition("MRGPV1", rep);
    }



}

