/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a BAR_P06 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: EVN (EVN - event type segment) <b> </b></li>
                 * <li>3: BAR_P06_PIDPV1 (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class BAR_P06 extends AbstractMessage  {

    /**
     * Creates a new BAR_P06 message with DefaultModelClassFactory. 
     */ 
    public BAR_P06() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new BAR_P06 message with custom ModelClassFactory.
     */
    public BAR_P06(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(BAR_P06_PIDPV1.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BAR_P06 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * EVN (EVN - event type segment) - creates it if necessary
     */
    public EVN getEVN() { 
       EVN ret = null;
       try {
          ret = (EVN)this.get("EVN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDPV1 (a Group object) - creates it if necessary
     */
    public BAR_P06_PIDPV1 getPIDPV1() { 
       BAR_P06_PIDPV1 ret = null;
       try {
          ret = (BAR_P06_PIDPV1)this.get("PIDPV1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPV1 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public BAR_P06_PIDPV1 getPIDPV1(int rep) { 
       BAR_P06_PIDPV1 ret = null;
       try {
          ret = (BAR_P06_PIDPV1)this.get("PIDPV1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPV1 
     */ 
    public int getPIDPV1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPV1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPV1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDPV1(BAR_P06_PIDPV1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDPV1", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPV1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public BAR_P06_PIDPV1 insertPIDPV1(int rep) throws HL7Exception { 
       return (BAR_P06_PIDPV1)super.insertRepetition("PIDPV1", rep);
    }


    /**
     * Removes a specific repetition of PIDPV1 (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public BAR_P06_PIDPV1 removePIDPV1(int rep) throws HL7Exception { 
       return (BAR_P06_PIDPV1)super.removeRepetition("PIDPV1", rep);
    }



}

