/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a CRM_C01 message structure (see chapter ${chapter}). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: CRM_C01_PIDPV1CSRCSP (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CRM_C01 extends AbstractMessage  {

    /**
     * Creates a new CRM_C01 message with DefaultModelClassFactory. 
     */ 
    public CRM_C01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new CRM_C01 message with custom ModelClassFactory.
     */
    public CRM_C01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(CRM_C01_PIDPV1CSRCSP.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CRM_C01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDPV1CSRCSP (a Group object) - creates it if necessary
     */
    public CRM_C01_PIDPV1CSRCSP getPIDPV1CSRCSP() { 
       CRM_C01_PIDPV1CSRCSP ret = null;
       try {
          ret = (CRM_C01_PIDPV1CSRCSP)this.get("PIDPV1CSRCSP");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPV1CSRCSP (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CRM_C01_PIDPV1CSRCSP getPIDPV1CSRCSP(int rep) { 
       CRM_C01_PIDPV1CSRCSP ret = null;
       try {
          ret = (CRM_C01_PIDPV1CSRCSP)this.get("PIDPV1CSRCSP", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPV1CSRCSP 
     */ 
    public int getPIDPV1CSRCSPReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPV1CSRCSP").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPV1CSRCSP (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDPV1CSRCSP(CRM_C01_PIDPV1CSRCSP structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDPV1CSRCSP", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPV1CSRCSP (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public CRM_C01_PIDPV1CSRCSP insertPIDPV1CSRCSP(int rep) throws HL7Exception { 
       return (CRM_C01_PIDPV1CSRCSP)super.insertRepetition("PIDPV1CSRCSP", rep);
    }


    /**
     * Removes a specific repetition of PIDPV1CSRCSP (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public CRM_C01_PIDPV1CSRCSP removePIDPV1CSRCSP(int rep) throws HL7Exception { 
       return (CRM_C01_PIDPV1CSRCSP)super.removeRepetition("PIDPV1CSRCSP", rep);
    }



}

