/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a CSU_C09 message structure (see chapter ${chapter}). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09 extends AbstractMessage  {

    /**
     * Creates a new CSU_C09 message with DefaultModelClassFactory. 
     */ 
    public CSU_C09() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new CSU_C09 message with custom ModelClassFactory.
     */
    public CSU_C09(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object) - creates it if necessary
     */
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR getPIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR() { 
       CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR ret = null;
       try {
          ret = (CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR)this.get("PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR getPIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(int rep) { 
       CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR ret = null;
       try {
          ret = (CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR)this.get("PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR 
     */ 
    public int getPIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR insertPIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR)super.insertRepetition("PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR", rep);
    }


    /**
     * Removes a specific repetition of PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR removePIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception { 
       return (CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR)super.removeRepetition("PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR", rep);
    }



}

