/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a DOC_T12 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: ERR (ERR - error segment) <b>optional </b></li>
                 * <li>4: QAK (Query Acknowledgement) <b>optional </b></li>
                 * <li>5: QRD (QRD - original-style query definition segment) <b> </b></li>
                 * <li>6: DOC_T12_EVNPIDPV1TXAOBX (a Group object) <b> repeating</b></li>
                 * <li>7: DSC (DSC - Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class DOC_T12 extends AbstractMessage  {

    /**
     * Creates a new DOC_T12 message with DefaultModelClassFactory. 
     */ 
    public DOC_T12() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new DOC_T12 message with custom ModelClassFactory.
     */
    public DOC_T12(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QAK.class, false, false);
                          this.add(QRD.class, true, false);
                          this.add(DOC_T12_EVNPIDPV1TXAOBX.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DOC_T12 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (ERR - error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QAK (Query Acknowledgement) - creates it if necessary
     */
    public QAK getQAK() { 
       QAK ret = null;
       try {
          ret = (QAK)this.get("QAK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * EVNPIDPV1TXAOBX (a Group object) - creates it if necessary
     */
    public DOC_T12_EVNPIDPV1TXAOBX getEVNPIDPV1TXAOBX() { 
       DOC_T12_EVNPIDPV1TXAOBX ret = null;
       try {
          ret = (DOC_T12_EVNPIDPV1TXAOBX)this.get("EVNPIDPV1TXAOBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * EVNPIDPV1TXAOBX (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DOC_T12_EVNPIDPV1TXAOBX getEVNPIDPV1TXAOBX(int rep) { 
       DOC_T12_EVNPIDPV1TXAOBX ret = null;
       try {
          ret = (DOC_T12_EVNPIDPV1TXAOBX)this.get("EVNPIDPV1TXAOBX", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of EVNPIDPV1TXAOBX 
     */ 
    public int getEVNPIDPV1TXAOBXReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("EVNPIDPV1TXAOBX").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of EVNPIDPV1TXAOBX (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertEVNPIDPV1TXAOBX(DOC_T12_EVNPIDPV1TXAOBX structure, int rep) throws HL7Exception { 
       super.insertRepetition( "EVNPIDPV1TXAOBX", structure, rep);
    }


    /**
     * Inserts a specific repetition of EVNPIDPV1TXAOBX (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public DOC_T12_EVNPIDPV1TXAOBX insertEVNPIDPV1TXAOBX(int rep) throws HL7Exception { 
       return (DOC_T12_EVNPIDPV1TXAOBX)super.insertRepetition("EVNPIDPV1TXAOBX", rep);
    }


    /**
     * Removes a specific repetition of EVNPIDPV1TXAOBX (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public DOC_T12_EVNPIDPV1TXAOBX removeEVNPIDPV1TXAOBX(int rep) throws HL7Exception { 
       return (DOC_T12_EVNPIDPV1TXAOBX)super.removeRepetition("EVNPIDPV1TXAOBX", rep);
    }



    /**
     * Returns
     * DSC (DSC - Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

