/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFN_M02 message structure (see chapter ${chapter}). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MFI (MFI - master file identification segment) <b> </b></li>
                 * <li>3: MFN_M02_MFESTFPRA (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class MFN_M02 extends AbstractMessage  {

    /**
     * Creates a new MFN_M02 message with DefaultModelClassFactory. 
     */ 
    public MFN_M02() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new MFN_M02 message with custom ModelClassFactory.
     */
    public MFN_M02(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MFI.class, true, false);
                          this.add(MFN_M02_MFESTFPRA.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M02 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MFI (MFI - master file identification segment) - creates it if necessary
     */
    public MFI getMFI() { 
       MFI ret = null;
       try {
          ret = (MFI)this.get("MFI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MFESTFPRA (a Group object) - creates it if necessary
     */
    public MFN_M02_MFESTFPRA getMFESTFPRA() { 
       MFN_M02_MFESTFPRA ret = null;
       try {
          ret = (MFN_M02_MFESTFPRA)this.get("MFESTFPRA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MFESTFPRA (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M02_MFESTFPRA getMFESTFPRA(int rep) { 
       MFN_M02_MFESTFPRA ret = null;
       try {
          ret = (MFN_M02_MFESTFPRA)this.get("MFESTFPRA", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MFESTFPRA 
     */ 
    public int getMFESTFPRAReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MFESTFPRA").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MFESTFPRA (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMFESTFPRA(MFN_M02_MFESTFPRA structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MFESTFPRA", structure, rep);
    }


    /**
     * Inserts a specific repetition of MFESTFPRA (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public MFN_M02_MFESTFPRA insertMFESTFPRA(int rep) throws HL7Exception { 
       return (MFN_M02_MFESTFPRA)super.insertRepetition("MFESTFPRA", rep);
    }


    /**
     * Removes a specific repetition of MFESTFPRA (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public MFN_M02_MFESTFPRA removeMFESTFPRA(int rep) throws HL7Exception { 
       return (MFN_M02_MFESTFPRA)super.removeRepetition("MFESTFPRA", rep);
    }



}

