/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMD_N02 message structure (see chapter 14). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NMD_N02_NCKNTENSTNTENSCNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class NMD_N02 extends AbstractMessage  {

    /**
     * Creates a new NMD_N02 message with DefaultModelClassFactory. 
     */ 
    public NMD_N02() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new NMD_N02 message with custom ModelClassFactory.
     */
    public NMD_N02(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NMD_N02_NCKNTENSTNTENSCNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMD_N02 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NCKNTENSTNTENSCNTE (a Group object) - creates it if necessary
     */
    public NMD_N02_NCKNTENSTNTENSCNTE getNCKNTENSTNTENSCNTE() { 
       NMD_N02_NCKNTENSTNTENSCNTE ret = null;
       try {
          ret = (NMD_N02_NCKNTENSTNTENSCNTE)this.get("NCKNTENSTNTENSCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NCKNTENSTNTENSCNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMD_N02_NCKNTENSTNTENSCNTE getNCKNTENSTNTENSCNTE(int rep) { 
       NMD_N02_NCKNTENSTNTENSCNTE ret = null;
       try {
          ret = (NMD_N02_NCKNTENSTNTENSCNTE)this.get("NCKNTENSTNTENSCNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NCKNTENSTNTENSCNTE 
     */ 
    public int getNCKNTENSTNTENSCNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NCKNTENSTNTENSCNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNCKNTENSTNTENSCNTE(NMD_N02_NCKNTENSTNTENSCNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NCKNTENSTNTENSCNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NMD_N02_NCKNTENSTNTENSCNTE insertNCKNTENSTNTENSCNTE(int rep) throws HL7Exception { 
       return (NMD_N02_NCKNTENSTNTENSCNTE)super.insertRepetition("NCKNTENSTNTENSCNTE", rep);
    }


    /**
     * Removes a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NMD_N02_NCKNTENSTNTENSCNTE removeNCKNTENSTNTENSCNTE(int rep) throws HL7Exception { 
       return (NMD_N02_NCKNTENSTNTENSCNTE)super.removeRepetition("NCKNTENSTNTENSCNTE", rep);
    }



}

