/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMQ_N01 message structure (see chapter 14). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NMQ_N01_QRDQRF (a Group object) <b>optional </b></li>
                 * <li>3: NMQ_N01_NCKNSTNSC (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class NMQ_N01 extends AbstractMessage  {

    /**
     * Creates a new NMQ_N01 message with DefaultModelClassFactory. 
     */ 
    public NMQ_N01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new NMQ_N01 message with custom ModelClassFactory.
     */
    public NMQ_N01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NMQ_N01_QRDQRF.class, false, false);
                          this.add(NMQ_N01_NCKNSTNSC.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRDQRF (a Group object) - creates it if necessary
     */
    public NMQ_N01_QRDQRF getQRDQRF() { 
       NMQ_N01_QRDQRF ret = null;
       try {
          ret = (NMQ_N01_QRDQRF)this.get("QRDQRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NCKNSTNSC (a Group object) - creates it if necessary
     */
    public NMQ_N01_NCKNSTNSC getNCKNSTNSC() { 
       NMQ_N01_NCKNSTNSC ret = null;
       try {
          ret = (NMQ_N01_NCKNSTNSC)this.get("NCKNSTNSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NCKNSTNSC (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMQ_N01_NCKNSTNSC getNCKNSTNSC(int rep) { 
       NMQ_N01_NCKNSTNSC ret = null;
       try {
          ret = (NMQ_N01_NCKNSTNSC)this.get("NCKNSTNSC", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NCKNSTNSC 
     */ 
    public int getNCKNSTNSCReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NCKNSTNSC").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNCKNSTNSC(NMQ_N01_NCKNSTNSC structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NCKNSTNSC", structure, rep);
    }


    /**
     * Inserts a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NMQ_N01_NCKNSTNSC insertNCKNSTNSC(int rep) throws HL7Exception { 
       return (NMQ_N01_NCKNSTNSC)super.insertRepetition("NCKNSTNSC", rep);
    }


    /**
     * Removes a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NMQ_N01_NCKNSTNSC removeNCKNSTNSC(int rep) throws HL7Exception { 
       return (NMQ_N01_NCKNSTNSC)super.removeRepetition("NCKNSTNSC", rep);
    }



}

