/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMR_N01 message structure (see chapter 14). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: ERR (ERR - error segment) <b>optional repeating</b></li>
                 * <li>4: QRD (QRD - original-style query definition segment) <b>optional </b></li>
                 * <li>5: NMR_N01_NCKNTENSTNTENSCNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class NMR_N01 extends AbstractMessage  {

    /**
     * Creates a new NMR_N01 message with DefaultModelClassFactory. 
     */ 
    public NMR_N01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new NMR_N01 message with custom ModelClassFactory.
     */
    public NMR_N01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, true);
                          this.add(QRD.class, false, false);
                          this.add(NMR_N01_NCKNTENSTNTENSCNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMR_N01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ERR (ERR - error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ERR (ERR - error segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ERR getERR(int rep) { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ERR 
     */ 
    public int getERRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ERR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ERR (ERR - error segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertERR(ERR structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ERR", structure, rep);
    }


    /**
     * Inserts a specific repetition of ERR (ERR - error segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ERR insertERR(int rep) throws HL7Exception { 
       return (ERR)super.insertRepetition("ERR", rep);
    }


    /**
     * Removes a specific repetition of ERR (ERR - error segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ERR removeERR(int rep) throws HL7Exception { 
       return (ERR)super.removeRepetition("ERR", rep);
    }



    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NCKNTENSTNTENSCNTE (a Group object) - creates it if necessary
     */
    public NMR_N01_NCKNTENSTNTENSCNTE getNCKNTENSTNTENSCNTE() { 
       NMR_N01_NCKNTENSTNTENSCNTE ret = null;
       try {
          ret = (NMR_N01_NCKNTENSTNTENSCNTE)this.get("NCKNTENSTNTENSCNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NCKNTENSTNTENSCNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMR_N01_NCKNTENSTNTENSCNTE getNCKNTENSTNTENSCNTE(int rep) { 
       NMR_N01_NCKNTENSTNTENSCNTE ret = null;
       try {
          ret = (NMR_N01_NCKNTENSTNTENSCNTE)this.get("NCKNTENSTNTENSCNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NCKNTENSTNTENSCNTE 
     */ 
    public int getNCKNTENSTNTENSCNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NCKNTENSTNTENSCNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNCKNTENSTNTENSCNTE(NMR_N01_NCKNTENSTNTENSCNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NCKNTENSTNTENSCNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NMR_N01_NCKNTENSTNTENSCNTE insertNCKNTENSTNTENSCNTE(int rep) throws HL7Exception { 
       return (NMR_N01_NCKNTENSTNTENSCNTE)super.insertRepetition("NCKNTENSTNTENSCNTE", rep);
    }


    /**
     * Removes a specific repetition of NCKNTENSTNTENSCNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NMR_N01_NCKNTENSTNTENSCNTE removeNCKNTENSTNTENSCNTE(int rep) throws HL7Exception { 
       return (NMR_N01_NCKNTENSTNTENSCNTE)super.removeRepetition("NCKNTENSTNTENSCNTE", rep);
    }



}

