/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a OMD_O01 message structure (see chapter 4.6). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>3: OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) <b>optional </b></li>
                 * <li>4: OMD_O01_ORCODSNTEOBXNTE (a Group object) <b> repeating</b></li>
                 * <li>5: OMD_O01_ORCODTNTE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class OMD_O01 extends AbstractMessage  {

    /**
     * Creates a new OMD_O01 message with DefaultModelClassFactory. 
     */ 
    public OMD_O01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new OMD_O01 message with custom ModelClassFactory.
     */
    public OMD_O01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
                          this.add(OMD_O01_ORCODSNTEOBXNTE.class, true, true);
                          this.add(OMD_O01_ORCODTNTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMD_O01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) - creates it if necessary
     */
    public OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() { 
       OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
       try {
          ret = (OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCODSNTEOBXNTE (a Group object) - creates it if necessary
     */
    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE() { 
       OMD_O01_ORCODSNTEOBXNTE ret = null;
       try {
          ret = (OMD_O01_ORCODSNTEOBXNTE)this.get("ORCODSNTEOBXNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCODSNTEOBXNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE(int rep) { 
       OMD_O01_ORCODSNTEOBXNTE ret = null;
       try {
          ret = (OMD_O01_ORCODSNTEOBXNTE)this.get("ORCODSNTEOBXNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCODSNTEOBXNTE 
     */ 
    public int getORCODSNTEOBXNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCODSNTEOBXNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCODSNTEOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCODSNTEOBXNTE(OMD_O01_ORCODSNTEOBXNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCODSNTEOBXNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCODSNTEOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public OMD_O01_ORCODSNTEOBXNTE insertORCODSNTEOBXNTE(int rep) throws HL7Exception { 
       return (OMD_O01_ORCODSNTEOBXNTE)super.insertRepetition("ORCODSNTEOBXNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCODSNTEOBXNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public OMD_O01_ORCODSNTEOBXNTE removeORCODSNTEOBXNTE(int rep) throws HL7Exception { 
       return (OMD_O01_ORCODSNTEOBXNTE)super.removeRepetition("ORCODSNTEOBXNTE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORCODTNTE (a Group object) - creates it if necessary
     */
    public OMD_O01_ORCODTNTE getORCODTNTE() { 
       OMD_O01_ORCODTNTE ret = null;
       try {
          ret = (OMD_O01_ORCODTNTE)this.get("ORCODTNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCODTNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OMD_O01_ORCODTNTE getORCODTNTE(int rep) { 
       OMD_O01_ORCODTNTE ret = null;
       try {
          ret = (OMD_O01_ORCODTNTE)this.get("ORCODTNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCODTNTE 
     */ 
    public int getORCODTNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCODTNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCODTNTE(OMD_O01_ORCODTNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCODTNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public OMD_O01_ORCODTNTE insertORCODTNTE(int rep) throws HL7Exception { 
       return (OMD_O01_ORCODTNTE)super.insertRepetition("ORCODTNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCODTNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public OMD_O01_ORCODTNTE removeORCODTNTE(int rep) throws HL7Exception { 
       return (OMD_O01_ORCODTNTE)super.removeRepetition("ORCODTNTE", rep);
    }



}

