/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a OMS_O01 message structure (see chapter 4.7). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>3: OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) <b>optional </b></li>
                 * <li>4: OMS_O01_ORCRQDNTEOBXNTEBLG (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class OMS_O01 extends AbstractMessage  {

    /**
     * Creates a new OMS_O01 message with DefaultModelClassFactory. 
     */ 
    public OMS_O01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new OMS_O01 message with custom ModelClassFactory.
     */
    public OMS_O01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
                          this.add(OMS_O01_ORCRQDNTEOBXNTEBLG.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMS_O01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) - creates it if necessary
     */
    public OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() { 
       OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
       try {
          ret = (OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRQDNTEOBXNTEBLG (a Group object) - creates it if necessary
     */
    public OMS_O01_ORCRQDNTEOBXNTEBLG getORCRQDNTEOBXNTEBLG() { 
       OMS_O01_ORCRQDNTEOBXNTEBLG ret = null;
       try {
          ret = (OMS_O01_ORCRQDNTEOBXNTEBLG)this.get("ORCRQDNTEOBXNTEBLG");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRQDNTEOBXNTEBLG (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OMS_O01_ORCRQDNTEOBXNTEBLG getORCRQDNTEOBXNTEBLG(int rep) { 
       OMS_O01_ORCRQDNTEOBXNTEBLG ret = null;
       try {
          ret = (OMS_O01_ORCRQDNTEOBXNTEBLG)this.get("ORCRQDNTEOBXNTEBLG", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRQDNTEOBXNTEBLG 
     */ 
    public int getORCRQDNTEOBXNTEBLGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRQDNTEOBXNTEBLG").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRQDNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCRQDNTEOBXNTEBLG(OMS_O01_ORCRQDNTEOBXNTEBLG structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCRQDNTEOBXNTEBLG", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRQDNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public OMS_O01_ORCRQDNTEOBXNTEBLG insertORCRQDNTEOBXNTEBLG(int rep) throws HL7Exception { 
       return (OMS_O01_ORCRQDNTEOBXNTEBLG)super.insertRepetition("ORCRQDNTEOBXNTEBLG", rep);
    }


    /**
     * Removes a specific repetition of ORCRQDNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public OMS_O01_ORCRQDNTEOBXNTEBLG removeORCRQDNTEOBXNTEBLG(int rep) throws HL7Exception { 
       return (OMS_O01_ORCRQDNTEOBXNTEBLG)super.removeRepetition("ORCRQDNTEOBXNTEBLG", rep);
    }



}

