/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ORF_R04 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: QRD (QRD - original-style query definition segment) <b> </b></li>
                 * <li>4: QRF (QRF - original style query filter segment) <b>optional </b></li>
                 * <li>5: ORF_R04_PIDNTEORCOBRNTEOBXNTECTI (a Group object) <b> repeating</b></li>
                 * <li>6: ERR (ERR - error segment) <b>optional </b></li>
                 * <li>7: QAK (Query Acknowledgement) <b>optional </b></li>
                 * <li>8: DSC (DSC - Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class ORF_R04 extends AbstractMessage  {

    /**
     * Creates a new ORF_R04 message with DefaultModelClassFactory. 
     */ 
    public ORF_R04() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ORF_R04 message with custom ModelClassFactory.
     */
    public ORF_R04(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(ORF_R04_PIDNTEORCOBRNTEOBXNTECTI.class, true, true);
                          this.add(ERR.class, false, false);
                          this.add(QAK.class, false, false);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (QRF - original style query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDNTEORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     */
    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI getPIDNTEORCOBRNTEOBXNTECTI() { 
       ORF_R04_PIDNTEORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)this.get("PIDNTEORCOBRNTEOBXNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDNTEORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI getPIDNTEORCOBRNTEOBXNTECTI(int rep) { 
       ORF_R04_PIDNTEORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)this.get("PIDNTEORCOBRNTEOBXNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDNTEORCOBRNTEOBXNTECTI 
     */ 
    public int getPIDNTEORCOBRNTEOBXNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDNTEORCOBRNTEOBXNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDNTEORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDNTEORCOBRNTEOBXNTECTI(ORF_R04_PIDNTEORCOBRNTEOBXNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDNTEORCOBRNTEOBXNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDNTEORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI insertPIDNTEORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)super.insertRepetition("PIDNTEORCOBRNTEOBXNTECTI", rep);
    }


    /**
     * Removes a specific repetition of PIDNTEORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ORF_R04_PIDNTEORCOBRNTEOBXNTECTI removePIDNTEORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORF_R04_PIDNTEORCOBRNTEOBXNTECTI)super.removeRepetition("PIDNTEORCOBRNTEOBXNTECTI", rep);
    }



    /**
     * Returns
     * ERR (ERR - error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QAK (Query Acknowledgement) - creates it if necessary
     */
    public QAK getQAK() { 
       QAK ret = null;
       try {
          ret = (QAK)this.get("QAK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * DSC (DSC - Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

