/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ORU_R01 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object) <b> repeating</b></li>
                 * <li>3: DSC (DSC - Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class ORU_R01 extends AbstractMessage  {

    /**
     * Creates a new ORU_R01 message with DefaultModelClassFactory. 
     */ 
    public ORU_R01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ORU_R01 message with custom ModelClassFactory.
     */
    public ORU_R01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORU_R01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI getPIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI() { 
       ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI)this.get("PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI getPIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI(int rep) { 
       ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI ret = null;
       try {
          ret = (ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI)this.get("PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI 
     */ 
    public int getPIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI(ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI insertPIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI)super.insertRepetition("PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI", rep);
    }


    /**
     * Removes a specific repetition of PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI removePIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI(int rep) throws HL7Exception { 
       return (ORU_R01_PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI)super.removeRepetition("PIDPD1NK1NTEPV1PV2ORCOBRNTEOBXNTECTI", rep);
    }



    /**
     * Returns
     * DSC (DSC - Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

