/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a RDO_O01 message structure (see chapter 4.8.1). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>3: RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) <b>optional </b></li>
                 * <li>4: RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RDO_O01 extends AbstractMessage  {

    /**
     * Creates a new RDO_O01 message with DefaultModelClassFactory. 
     */ 
    public RDO_O01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new RDO_O01 message with custom ModelClassFactory.
     */
    public RDO_O01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
                          this.add(RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDO_O01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 (a Group object) - creates it if necessary
     */
    public RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() { 
       RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
       try {
          ret = (RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object) - creates it if necessary
     */
    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG getORCRXONTERXRRXCNTEOBXNTEBLG() { 
       RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG ret = null;
       try {
          ret = (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)this.get("ORCRXONTERXRRXCNTEOBXNTEBLG");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG getORCRXONTERXRRXCNTEOBXNTEBLG(int rep) { 
       RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG ret = null;
       try {
          ret = (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)this.get("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXONTERXRRXCNTEOBXNTEBLG 
     */ 
    public int getORCRXONTERXRRXCNTEOBXNTEBLGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXONTERXRRXCNTEOBXNTEBLG").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCRXONTERXRRXCNTEOBXNTEBLG(RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCRXONTERXRRXCNTEOBXNTEBLG", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG insertORCRXONTERXRRXCNTEOBXNTEBLG(int rep) throws HL7Exception { 
       return (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)super.insertRepetition("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
    }


    /**
     * Removes a specific repetition of ORCRXONTERXRRXCNTEOBXNTEBLG (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG removeORCRXONTERXRRXCNTEOBXNTEBLG(int rep) throws HL7Exception { 
       return (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)super.removeRepetition("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
    }



}

