/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a RGV_O01 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
                 * <li>3: RGV_O01_PIDNTEAL1PV1PV2 (a Group object) <b>optional </b></li>
                 * <li>4: RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class RGV_O01 extends AbstractMessage  {

    /**
     * Creates a new RGV_O01 message with DefaultModelClassFactory. 
     */ 
    public RGV_O01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new RGV_O01 message with custom ModelClassFactory.
     */
    public RGV_O01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NTE.class, false, true);
                          this.add(RGV_O01_PIDNTEAL1PV1PV2.class, false, false);
                          this.add(RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGV_O01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * PIDNTEAL1PV1PV2 (a Group object) - creates it if necessary
     */
    public RGV_O01_PIDNTEAL1PV1PV2 getPIDNTEAL1PV1PV2() { 
       RGV_O01_PIDNTEAL1PV1PV2 ret = null;
       try {
          ret = (RGV_O01_PIDNTEAL1PV1PV2)this.get("PIDNTEAL1PV1PV2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object) - creates it if necessary
     */
    public RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE getORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE() { 
       RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE ret = null;
       try {
          ret = (RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE)this.get("ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE getORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE(int rep) { 
       RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE ret = null;
       try {
          ret = (RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE)this.get("ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE 
     */ 
    public int getORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE(RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE insertORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE(int rep) throws HL7Exception { 
       return (RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE)super.insertRepetition("ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE removeORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE(int rep) throws HL7Exception { 
       return (RGV_O01_ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE)super.removeRepetition("ORCRXONTERXRRXCNTERXERXRRXCRXGRXRRXCOBXNTE", rep);
    }



}

