/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a RQA_I08 message structure (see chapter ${chapter}). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: RF1 (Referral Infomation) <b>optional </b></li>
                 * <li>3: RQA_I08_AUTCTD (a Group object) <b>optional </b></li>
                 * <li>4: RQA_I08_PRDCTD (a Group object) <b> repeating</b></li>
                 * <li>5: PID (PID - patient identification segment) <b> </b></li>
                 * <li>6: NK1 (NK1 - next of kin / associated parties segment-) <b>optional repeating</b></li>
                 * <li>7: RQA_I08_GT1IN1IN2IN3 (a Group object) <b>optional </b></li>
                 * <li>8: ACC (ACC - accident segment) <b>optional </b></li>
                 * <li>9: DG1 (DG1 - diagnosis segment) <b>optional repeating</b></li>
                 * <li>10: DRG (DRG - diagnosis related group segment) <b>optional repeating</b></li>
                 * <li>11: AL1 (AL1 - patient allergy information segment) <b>optional repeating</b></li>
                 * <li>12: RQA_I08_PR1AUTCTD (a Group object) <b>optional repeating</b></li>
                 * <li>13: RQA_I08_OBRNTEOBXNTE (a Group object) <b>optional repeating</b></li>
                 * <li>14: RQA_I08_PV1PV2 (a Group object) <b>optional </b></li>
                 * <li>15: NTE (NTE - notes and comments segment) <b>optional repeating</b></li>
 * </ul>
 */
public class RQA_I08 extends AbstractMessage  {

    /**
     * Creates a new RQA_I08 message with DefaultModelClassFactory. 
     */ 
    public RQA_I08() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new RQA_I08 message with custom ModelClassFactory.
     */
    public RQA_I08(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(RF1.class, false, false);
                          this.add(RQA_I08_AUTCTD.class, false, false);
                          this.add(RQA_I08_PRDCTD.class, true, true);
                          this.add(PID.class, true, false);
                          this.add(NK1.class, false, true);
                          this.add(RQA_I08_GT1IN1IN2IN3.class, false, false);
                          this.add(ACC.class, false, false);
                          this.add(DG1.class, false, true);
                          this.add(DRG.class, false, true);
                          this.add(AL1.class, false, true);
                          this.add(RQA_I08_PR1AUTCTD.class, false, true);
                          this.add(RQA_I08_OBRNTEOBXNTE.class, false, true);
                          this.add(RQA_I08_PV1PV2.class, false, false);
                          this.add(NTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RQA_I08 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RF1 (Referral Infomation) - creates it if necessary
     */
    public RF1 getRF1() { 
       RF1 ret = null;
       try {
          ret = (RF1)this.get("RF1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * AUTCTD (a Group object) - creates it if necessary
     */
    public RQA_I08_AUTCTD getAUTCTD() { 
       RQA_I08_AUTCTD ret = null;
       try {
          ret = (RQA_I08_AUTCTD)this.get("AUTCTD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PRDCTD (a Group object) - creates it if necessary
     */
    public RQA_I08_PRDCTD getPRDCTD() { 
       RQA_I08_PRDCTD ret = null;
       try {
          ret = (RQA_I08_PRDCTD)this.get("PRDCTD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRDCTD (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RQA_I08_PRDCTD getPRDCTD(int rep) { 
       RQA_I08_PRDCTD ret = null;
       try {
          ret = (RQA_I08_PRDCTD)this.get("PRDCTD", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRDCTD 
     */ 
    public int getPRDCTDReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRDCTD").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRDCTD (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPRDCTD(RQA_I08_PRDCTD structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PRDCTD", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRDCTD (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RQA_I08_PRDCTD insertPRDCTD(int rep) throws HL7Exception { 
       return (RQA_I08_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }


    /**
     * Removes a specific repetition of PRDCTD (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RQA_I08_PRDCTD removePRDCTD(int rep) throws HL7Exception { 
       return (RQA_I08_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }



    /**
     * Returns
     * PID (PID - patient identification segment) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NK1 (NK1 - next of kin / associated parties segment-) - creates it if necessary
     */
    public NK1 getNK1() { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NK1 (NK1 - next of kin / associated parties segment-) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NK1 getNK1(int rep) { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NK1 
     */ 
    public int getNK1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NK1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNK1(NK1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NK1", structure, rep);
    }


    /**
     * Inserts a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NK1 insertNK1(int rep) throws HL7Exception { 
       return (NK1)super.insertRepetition("NK1", rep);
    }


    /**
     * Removes a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NK1 removeNK1(int rep) throws HL7Exception { 
       return (NK1)super.removeRepetition("NK1", rep);
    }



    /**
     * Returns
     * GT1IN1IN2IN3 (a Group object) - creates it if necessary
     */
    public RQA_I08_GT1IN1IN2IN3 getGT1IN1IN2IN3() { 
       RQA_I08_GT1IN1IN2IN3 ret = null;
       try {
          ret = (RQA_I08_GT1IN1IN2IN3)this.get("GT1IN1IN2IN3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ACC (ACC - accident segment) - creates it if necessary
     */
    public ACC getACC() { 
       ACC ret = null;
       try {
          ret = (ACC)this.get("ACC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * DG1 (DG1 - diagnosis segment) - creates it if necessary
     */
    public DG1 getDG1() { 
       DG1 ret = null;
       try {
          ret = (DG1)this.get("DG1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * DG1 (DG1 - diagnosis segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DG1 getDG1(int rep) { 
       DG1 ret = null;
       try {
          ret = (DG1)this.get("DG1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of DG1 
     */ 
    public int getDG1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("DG1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of DG1 (DG1 - diagnosis segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertDG1(DG1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "DG1", structure, rep);
    }


    /**
     * Inserts a specific repetition of DG1 (DG1 - diagnosis segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public DG1 insertDG1(int rep) throws HL7Exception { 
       return (DG1)super.insertRepetition("DG1", rep);
    }


    /**
     * Removes a specific repetition of DG1 (DG1 - diagnosis segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public DG1 removeDG1(int rep) throws HL7Exception { 
       return (DG1)super.removeRepetition("DG1", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * DRG (DRG - diagnosis related group segment) - creates it if necessary
     */
    public DRG getDRG() { 
       DRG ret = null;
       try {
          ret = (DRG)this.get("DRG");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * DRG (DRG - diagnosis related group segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DRG getDRG(int rep) { 
       DRG ret = null;
       try {
          ret = (DRG)this.get("DRG", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of DRG 
     */ 
    public int getDRGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("DRG").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of DRG (DRG - diagnosis related group segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertDRG(DRG structure, int rep) throws HL7Exception { 
       super.insertRepetition( "DRG", structure, rep);
    }


    /**
     * Inserts a specific repetition of DRG (DRG - diagnosis related group segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public DRG insertDRG(int rep) throws HL7Exception { 
       return (DRG)super.insertRepetition("DRG", rep);
    }


    /**
     * Removes a specific repetition of DRG (DRG - diagnosis related group segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public DRG removeDRG(int rep) throws HL7Exception { 
       return (DRG)super.removeRepetition("DRG", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * AL1 (AL1 - patient allergy information segment) - creates it if necessary
     */
    public AL1 getAL1() { 
       AL1 ret = null;
       try {
          ret = (AL1)this.get("AL1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AL1 (AL1 - patient allergy information segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public AL1 getAL1(int rep) { 
       AL1 ret = null;
       try {
          ret = (AL1)this.get("AL1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AL1 
     */ 
    public int getAL1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AL1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AL1 (AL1 - patient allergy information segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertAL1(AL1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "AL1", structure, rep);
    }


    /**
     * Inserts a specific repetition of AL1 (AL1 - patient allergy information segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public AL1 insertAL1(int rep) throws HL7Exception { 
       return (AL1)super.insertRepetition("AL1", rep);
    }


    /**
     * Removes a specific repetition of AL1 (AL1 - patient allergy information segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public AL1 removeAL1(int rep) throws HL7Exception { 
       return (AL1)super.removeRepetition("AL1", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PR1AUTCTD (a Group object) - creates it if necessary
     */
    public RQA_I08_PR1AUTCTD getPR1AUTCTD() { 
       RQA_I08_PR1AUTCTD ret = null;
       try {
          ret = (RQA_I08_PR1AUTCTD)this.get("PR1AUTCTD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PR1AUTCTD (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RQA_I08_PR1AUTCTD getPR1AUTCTD(int rep) { 
       RQA_I08_PR1AUTCTD ret = null;
       try {
          ret = (RQA_I08_PR1AUTCTD)this.get("PR1AUTCTD", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PR1AUTCTD 
     */ 
    public int getPR1AUTCTDReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PR1AUTCTD").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PR1AUTCTD (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPR1AUTCTD(RQA_I08_PR1AUTCTD structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PR1AUTCTD", structure, rep);
    }


    /**
     * Inserts a specific repetition of PR1AUTCTD (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RQA_I08_PR1AUTCTD insertPR1AUTCTD(int rep) throws HL7Exception { 
       return (RQA_I08_PR1AUTCTD)super.insertRepetition("PR1AUTCTD", rep);
    }


    /**
     * Removes a specific repetition of PR1AUTCTD (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RQA_I08_PR1AUTCTD removePR1AUTCTD(int rep) throws HL7Exception { 
       return (RQA_I08_PR1AUTCTD)super.removeRepetition("PR1AUTCTD", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * OBRNTEOBXNTE (a Group object) - creates it if necessary
     */
    public RQA_I08_OBRNTEOBXNTE getOBRNTEOBXNTE() { 
       RQA_I08_OBRNTEOBXNTE ret = null;
       try {
          ret = (RQA_I08_OBRNTEOBXNTE)this.get("OBRNTEOBXNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * OBRNTEOBXNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RQA_I08_OBRNTEOBXNTE getOBRNTEOBXNTE(int rep) { 
       RQA_I08_OBRNTEOBXNTE ret = null;
       try {
          ret = (RQA_I08_OBRNTEOBXNTE)this.get("OBRNTEOBXNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of OBRNTEOBXNTE 
     */ 
    public int getOBRNTEOBXNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("OBRNTEOBXNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of OBRNTEOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertOBRNTEOBXNTE(RQA_I08_OBRNTEOBXNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "OBRNTEOBXNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBRNTEOBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RQA_I08_OBRNTEOBXNTE insertOBRNTEOBXNTE(int rep) throws HL7Exception { 
       return (RQA_I08_OBRNTEOBXNTE)super.insertRepetition("OBRNTEOBXNTE", rep);
    }


    /**
     * Removes a specific repetition of OBRNTEOBXNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RQA_I08_OBRNTEOBXNTE removeOBRNTEOBXNTE(int rep) throws HL7Exception { 
       return (RQA_I08_OBRNTEOBXNTE)super.removeRepetition("OBRNTEOBXNTE", rep);
    }



    /**
     * Returns
     * PV1PV2 (a Group object) - creates it if necessary
     */
    public RQA_I08_PV1PV2 getPV1PV2() { 
       RQA_I08_PV1PV2 ret = null;
       try {
          ret = (RQA_I08_PV1PV2)this.get("PV1PV2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NTE - notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NTE - notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NTE - notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



}

