/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a SQR_S25 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: ERR (ERR - error segment) <b>optional </b></li>
                 * <li>4: QAK (Query Acknowledgement) <b> </b></li>
                 * <li>5: SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object) <b>optional repeating</b></li>
                 * <li>6: DSC (DSC - Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class SQR_S25 extends AbstractMessage  {

    /**
     * Creates a new SQR_S25 message with DefaultModelClassFactory. 
     */ 
    public SQR_S25() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new SQR_S25 message with custom ModelClassFactory.
     */
    public SQR_S25(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QAK.class, true, false);
                          this.add(SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE.class, false, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SQR_S25 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (ERR - error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QAK (Query Acknowledgement) - creates it if necessary
     */
    public QAK getQAK() { 
       QAK ret = null;
       try {
          ret = (QAK)this.get("QAK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object) - creates it if necessary
     */
    public SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE getSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE() { 
       SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE ret = null;
       try {
          ret = (SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE)this.get("SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE getSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE(int rep) { 
       SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE ret = null;
       try {
          ret = (SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE)this.get("SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE 
     */ 
    public int getSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE(SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE insertSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE(int rep) throws HL7Exception { 
       return (SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE)super.insertRepetition("SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
    }


    /**
     * Removes a specific repetition of SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE removeSCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE(int rep) throws HL7Exception { 
       return (SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE)super.removeRepetition("SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
    }



    /**
     * Returns
     * DSC (DSC - Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

