/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a TBR_R08 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: ERR (ERR - error segment) <b>optional </b></li>
                 * <li>4: QAK (Query Acknowledgement) <b> </b></li>
                 * <li>5: RDF (RDF - table row definition segment) <b> </b></li>
                 * <li>6: RDT (RDT - table row data segment) <b> repeating</b></li>
                 * <li>7: DSC (DSC - Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class TBR_R08 extends AbstractMessage  {

    /**
     * Creates a new TBR_R08 message with DefaultModelClassFactory. 
     */ 
    public TBR_R08() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new TBR_R08 message with custom ModelClassFactory.
     */
    public TBR_R08(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QAK.class, true, false);
                          this.add(RDF.class, true, false);
                          this.add(RDT.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TBR_R08 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (ERR - error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QAK (Query Acknowledgement) - creates it if necessary
     */
    public QAK getQAK() { 
       QAK ret = null;
       try {
          ret = (QAK)this.get("QAK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RDF (RDF - table row definition segment) - creates it if necessary
     */
    public RDF getRDF() { 
       RDF ret = null;
       try {
          ret = (RDF)this.get("RDF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RDT (RDT - table row data segment) - creates it if necessary
     */
    public RDT getRDT() { 
       RDT ret = null;
       try {
          ret = (RDT)this.get("RDT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RDT (RDT - table row data segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RDT getRDT(int rep) { 
       RDT ret = null;
       try {
          ret = (RDT)this.get("RDT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RDT 
     */ 
    public int getRDTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RDT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RDT (RDT - table row data segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertRDT(RDT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "RDT", structure, rep);
    }


    /**
     * Inserts a specific repetition of RDT (RDT - table row data segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RDT insertRDT(int rep) throws HL7Exception { 
       return (RDT)super.insertRepetition("RDT", rep);
    }


    /**
     * Removes a specific repetition of RDT (RDT - table row data segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RDT removeRDT(int rep) throws HL7Exception { 
       return (RDT)super.removeRepetition("RDT", rep);
    }



    /**
     * Returns
     * DSC (DSC - Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

