/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a VXU_V04 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: PID (PID - patient identification segment) <b> </b></li>
                 * <li>3: PD1 (PD1 - patient additional demographic segment) <b>optional </b></li>
                 * <li>4: NK1 (NK1 - next of kin / associated parties segment-) <b>optional repeating</b></li>
                 * <li>5: VXU_V04_PV1PV2 (a Group object) <b>optional </b></li>
                 * <li>6: VXU_V04_IN1IN2IN3 (a Group object) <b>optional repeating</b></li>
                 * <li>7: VXU_V04_ORCRXARXROBXNTE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class VXU_V04 extends AbstractMessage  {

    /**
     * Creates a new VXU_V04 message with DefaultModelClassFactory. 
     */ 
    public VXU_V04() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new VXU_V04 message with custom ModelClassFactory.
     */
    public VXU_V04(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PD1.class, false, false);
                          this.add(NK1.class, false, true);
                          this.add(VXU_V04_PV1PV2.class, false, false);
                          this.add(VXU_V04_IN1IN2IN3.class, false, true);
                          this.add(VXU_V04_ORCRXARXROBXNTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXU_V04 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (PID - patient identification segment) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PD1 (PD1 - patient additional demographic segment) - creates it if necessary
     */
    public PD1 getPD1() { 
       PD1 ret = null;
       try {
          ret = (PD1)this.get("PD1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NK1 (NK1 - next of kin / associated parties segment-) - creates it if necessary
     */
    public NK1 getNK1() { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NK1 (NK1 - next of kin / associated parties segment-) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NK1 getNK1(int rep) { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NK1 
     */ 
    public int getNK1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NK1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNK1(NK1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NK1", structure, rep);
    }


    /**
     * Inserts a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NK1 insertNK1(int rep) throws HL7Exception { 
       return (NK1)super.insertRepetition("NK1", rep);
    }


    /**
     * Removes a specific repetition of NK1 (NK1 - next of kin / associated parties segment-)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NK1 removeNK1(int rep) throws HL7Exception { 
       return (NK1)super.removeRepetition("NK1", rep);
    }



    /**
     * Returns
     * PV1PV2 (a Group object) - creates it if necessary
     */
    public VXU_V04_PV1PV2 getPV1PV2() { 
       VXU_V04_PV1PV2 ret = null;
       try {
          ret = (VXU_V04_PV1PV2)this.get("PV1PV2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * IN1IN2IN3 (a Group object) - creates it if necessary
     */
    public VXU_V04_IN1IN2IN3 getIN1IN2IN3() { 
       VXU_V04_IN1IN2IN3 ret = null;
       try {
          ret = (VXU_V04_IN1IN2IN3)this.get("IN1IN2IN3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * IN1IN2IN3 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public VXU_V04_IN1IN2IN3 getIN1IN2IN3(int rep) { 
       VXU_V04_IN1IN2IN3 ret = null;
       try {
          ret = (VXU_V04_IN1IN2IN3)this.get("IN1IN2IN3", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of IN1IN2IN3 
     */ 
    public int getIN1IN2IN3Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("IN1IN2IN3").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of IN1IN2IN3 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertIN1IN2IN3(VXU_V04_IN1IN2IN3 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "IN1IN2IN3", structure, rep);
    }


    /**
     * Inserts a specific repetition of IN1IN2IN3 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public VXU_V04_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception { 
       return (VXU_V04_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }


    /**
     * Removes a specific repetition of IN1IN2IN3 (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public VXU_V04_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception { 
       return (VXU_V04_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORCRXARXROBXNTE (a Group object) - creates it if necessary
     */
    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE() { 
       VXU_V04_ORCRXARXROBXNTE ret = null;
       try {
          ret = (VXU_V04_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORCRXARXROBXNTE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE(int rep) { 
       VXU_V04_ORCRXARXROBXNTE ret = null;
       try {
          ret = (VXU_V04_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORCRXARXROBXNTE 
     */ 
    public int getORCRXARXROBXNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORCRXARXROBXNTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORCRXARXROBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORCRXARXROBXNTE(VXU_V04_ORCRXARXROBXNTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORCRXARXROBXNTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORCRXARXROBXNTE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public VXU_V04_ORCRXARXROBXNTE insertORCRXARXROBXNTE(int rep) throws HL7Exception { 
       return (VXU_V04_ORCRXARXROBXNTE)super.insertRepetition("ORCRXARXROBXNTE", rep);
    }


    /**
     * Removes a specific repetition of ORCRXARXROBXNTE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public VXU_V04_ORCRXARXROBXNTE removeORCRXARXROBXNTE(int rep) throws HL7Exception { 
       return (VXU_V04_ORCRXARXROBXNTE)super.removeRepetition("ORCRXARXROBXNTE", rep);
    }



}

