/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a VXX_V02 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: MSA (MSA - message acknowledgment segment) <b> </b></li>
                 * <li>3: QRD (QRD - original-style query definition segment) <b> </b></li>
                 * <li>4: QRF (QRF - original style query filter segment) <b>optional </b></li>
                 * <li>5: VXX_V02_PIDNK1 (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class VXX_V02 extends AbstractMessage  {

    /**
     * Creates a new VXX_V02 message with DefaultModelClassFactory. 
     */ 
    public VXX_V02() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new VXX_V02 message with custom ModelClassFactory.
     */
    public VXX_V02(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(VXX_V02_PIDNK1.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXX_V02 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MSA - message acknowledgment segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (QRD - original-style query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (QRF - original style query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PIDNK1 (a Group object) - creates it if necessary
     */
    public VXX_V02_PIDNK1 getPIDNK1() { 
       VXX_V02_PIDNK1 ret = null;
       try {
          ret = (VXX_V02_PIDNK1)this.get("PIDNK1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PIDNK1 (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public VXX_V02_PIDNK1 getPIDNK1(int rep) { 
       VXX_V02_PIDNK1 ret = null;
       try {
          ret = (VXX_V02_PIDNK1)this.get("PIDNK1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PIDNK1 
     */ 
    public int getPIDNK1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PIDNK1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PIDNK1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPIDNK1(VXX_V02_PIDNK1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PIDNK1", structure, rep);
    }


    /**
     * Inserts a specific repetition of PIDNK1 (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public VXX_V02_PIDNK1 insertPIDNK1(int rep) throws HL7Exception { 
       return (VXX_V02_PIDNK1)super.insertRepetition("PIDNK1", rep);
    }


    /**
     * Removes a specific repetition of PIDNK1 (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public VXX_V02_PIDNK1 removePIDNK1(int rep) throws HL7Exception { 
       return (VXX_V02_PIDNK1)super.removeRepetition("PIDNK1", rep);
    }



}

