/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.segment;

// import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 AIS message segment (AIS - appointment information - service segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>AIS-1: Set ID - AIS (SI) <b> </b>
     * <li>AIS-2: Segment Action Code (ID) <b>optional </b>
     * <li>AIS-3: Universal Service ID (CE) <b> </b>
     * <li>AIS-4: Start Date/Time (TS) <b>optional </b>
     * <li>AIS-5: Start Date/Time Offset (NM) <b>optional </b>
     * <li>AIS-6: Start Date/Time Offset Units (CE) <b>optional </b>
     * <li>AIS-7: Duration (NM) <b>optional </b>
     * <li>AIS-8: Duration Units (CE) <b>optional </b>
     * <li>AIS-9: Allow Substitution Code (IS) <b>optional </b>
     * <li>AIS-10: Filler Status Code (CE) <b>optional </b>
 * </ul>
 */
public class AIS extends AbstractSegment {

    /** 
     * Creates a new AIS segment
     */
    public AIS(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - AIS");
                                  this.add(ID.class, false, 1, 3, new Object[]{ getMessage() }, "Segment Action Code");
                                  this.add(CE.class, true, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Universal Service ID");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Start Date/Time");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Start Date/Time Offset");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Start Date/Time Offset Units");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Duration");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Duration Units");
                                  this.add(IS.class, false, 1, 10, new Object[]{ getMessage() }, "Allow Substitution Code");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(278) }, "Filler Status Code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating AIS - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * AIS-1: "Set ID - AIS" - creates it if necessary
     */
    public SI getSetIDAIS() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-1: "Set ID - AIS" - creates it if necessary
     */
    public SI getAis1_SetIDAIS() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-2: "Segment Action Code" - creates it if necessary
     */
    public ID getSegmentActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-2: "Segment Action Code" - creates it if necessary
     */
    public ID getAis2_SegmentActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-3: "Universal Service ID" - creates it if necessary
     */
    public CE getUniversalServiceID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-3: "Universal Service ID" - creates it if necessary
     */
    public CE getAis3_UniversalServiceID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-4: "Start Date/Time" - creates it if necessary
     */
    public TS getStartDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-4: "Start Date/Time" - creates it if necessary
     */
    public TS getAis4_StartDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-5: "Start Date/Time Offset" - creates it if necessary
     */
    public NM getStartDateTimeOffset() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-5: "Start Date/Time Offset" - creates it if necessary
     */
    public NM getAis5_StartDateTimeOffset() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-6: "Start Date/Time Offset Units" - creates it if necessary
     */
    public CE getStartDateTimeOffsetUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-6: "Start Date/Time Offset Units" - creates it if necessary
     */
    public CE getAis6_StartDateTimeOffsetUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-7: "Duration" - creates it if necessary
     */
    public NM getDuration() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-7: "Duration" - creates it if necessary
     */
    public NM getAis7_Duration() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-8: "Duration Units" - creates it if necessary
     */
    public CE getDurationUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-8: "Duration Units" - creates it if necessary
     */
    public CE getAis8_DurationUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-9: "Allow Substitution Code" - creates it if necessary
     */
    public IS getAllowSubstitutionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-9: "Allow Substitution Code" - creates it if necessary
     */
    public IS getAis9_AllowSubstitutionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AIS-10: "Filler Status Code" - creates it if necessary
     */
    public CE getFillerStatusCode() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AIS-10: "Filler Status Code" - creates it if necessary
     */
    public CE getAis10_FillerStatusCode() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 206 ));
          case 2: return new CE(getMessage());
          case 3: return new TS(getMessage());
          case 4: return new NM(getMessage());
          case 5: return new CE(getMessage());
          case 6: return new NM(getMessage());
          case 7: return new CE(getMessage());
          case 8: return new IS(getMessage(), new Integer( 279 ));
          case 9: return new CE(getMessage());
          default: return null;
       }
   }


}

