/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.segment;

// import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OM1 message segment (OM1 - general segment (fields that apply to most observations)). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OM1-1: Sequence Number - Test/Observation Master File (NM) <b>optional </b>
     * <li>OM1-2: Producer's Test/Observation ID (CE) <b>optional </b>
     * <li>OM1-3: Permitted Data Types (ID) <b>optional repeating</b>
     * <li>OM1-4: Specimen Required (ID) <b>optional </b>
     * <li>OM1-5: Producer ID (CE) <b>optional </b>
     * <li>OM1-6: Observation Description (TX) <b>optional </b>
     * <li>OM1-7: Other Test/Observation IDs for the Observation (CE) <b>optional </b>
     * <li>OM1-8: Other Names (ST) <b>optional repeating</b>
     * <li>OM1-9: Preferred Report Name for the Observation (ST) <b>optional </b>
     * <li>OM1-10: Preferred Short Name or Mnemonic for Observation (ST) <b>optional </b>
     * <li>OM1-11: Preferred Long Name for the Observation (ST) <b>optional </b>
     * <li>OM1-12: Orderability (ID) <b>optional </b>
     * <li>OM1-13: Identity of Instrument Used to Perform this Study (CE) <b>optional repeating</b>
     * <li>OM1-14: Coded Representation of Method (CE) <b>optional repeating</b>
     * <li>OM1-15: Portable (ID) <b>optional </b>
     * <li>OM1-16: Observation Producing Department/Section (CE) <b>optional repeating</b>
     * <li>OM1-17: Telephone Number of Section (XTN) <b>optional </b>
     * <li>OM1-18: Nature of Test/Observation (IS) <b> </b>
     * <li>OM1-19: Report Subheader (CE) <b>optional </b>
     * <li>OM1-20: Report Display Order (ST) <b>optional </b>
     * <li>OM1-21: Date/Time Stamp for any change in Definition for the Observation (TS) <b>optional </b>
     * <li>OM1-22: Effective Date/Time of Change (TS) <b>optional </b>
     * <li>OM1-23: Typical Turn-Around Time (NM) <b>optional </b>
     * <li>OM1-24: Processing Time (NM) <b>optional </b>
     * <li>OM1-25: Processing Priority (ID) <b>optional repeating</b>
     * <li>OM1-26: Reporting Priority (ID) <b>optional </b>
     * <li>OM1-27: Outside Site(s) Where Observation may be Performed (CE) <b>optional repeating</b>
     * <li>OM1-28: Address of Outside Site(s) (XAD) <b>optional repeating</b>
     * <li>OM1-29: Phone Number of Outside Site (XTN) <b>optional </b>
     * <li>OM1-30: Confidentiality Code (IS) <b>optional </b>
     * <li>OM1-31: Observations Required to Interpret the Obs (CE) <b>optional </b>
     * <li>OM1-32: Interpretation of Observations (TX) <b>optional </b>
     * <li>OM1-33: Contraindications to Observations (CE) <b>optional </b>
     * <li>OM1-34: Reflex Tests/Observations (CE) <b>optional repeating</b>
     * <li>OM1-35: Rules that Trigger Reflex Testing (TX) <b>optional </b>
     * <li>OM1-36: Fixed Canned Message (CE) <b>optional </b>
     * <li>OM1-37: Patient Preparation (TX) <b>optional </b>
     * <li>OM1-38: Procedure Medication (CE) <b>optional </b>
     * <li>OM1-39: Factors that may Effect the Observation (TX) <b>optional </b>
     * <li>OM1-40: Test/Observation Performance Schedule (ST) <b>optional repeating</b>
     * <li>OM1-41: Description of Test Methods (TX) <b>optional </b>
     * <li>OM1-42: Kind of Quantity Observed (CE) <b>optional </b>
     * <li>OM1-43: Point Versus Interval (CE) <b>optional </b>
     * <li>OM1-44: Challenge Information (TX) <b>optional </b>
     * <li>OM1-45: Relationship Modifier (CE) <b>optional </b>
     * <li>OM1-46: Target Anatomic Site Of Test (CE) <b>optional </b>
     * <li>OM1-47: Modality Of Imaging Measurement (CE) <b>optional </b>
 * </ul>
 */
public class OM1 extends AbstractSegment {

    /** 
     * Creates a new OM1 segment
     */
    public OM1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Sequence Number - Test/Observation Master File");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Producer's Test/Observation ID");
                                  this.add(ID.class, false, 0, 12, new Object[]{ getMessage() }, "Permitted Data Types");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Specimen Required");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Producer ID");
                                  this.add(TX.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Observation Description");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Other Test/Observation IDs for the Observation");
                                  this.add(ST.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Other Names");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Preferred Report Name for the Observation");
                                  this.add(ST.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Preferred Short Name or Mnemonic for Observation");
                                  this.add(ST.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Preferred Long Name for the Observation");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Orderability");
                                  this.add(CE.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Identity of Instrument Used to Perform this Study");
                                  this.add(CE.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Coded Representation of Method");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Portable");
                                  this.add(CE.class, false, 0, 1, new Object[]{ getMessage(), new Integer(0) }, "Observation Producing Department/Section");
                                  this.add(XTN.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "Telephone Number of Section");
                                  this.add(IS.class, true, 1, 1, new Object[]{ getMessage() }, "Nature of Test/Observation");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Report Subheader");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Report Display Order");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Date/Time Stamp for any change in Definition for the Observation");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Effective Date/Time of Change");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Typical Turn-Around Time");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Processing Time");
                                  this.add(ID.class, false, 0, 40, new Object[]{ getMessage() }, "Processing Priority");
                                  this.add(ID.class, false, 1, 5, new Object[]{ getMessage() }, "Reporting Priority");
                                  this.add(CE.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Outside Site(s) Where Observation may be Performed");
                                  this.add(XAD.class, false, 0, 1000, new Object[]{ getMessage(), new Integer(0) }, "Address of Outside Site(s)");
                                  this.add(XTN.class, false, 1, 400, new Object[]{ getMessage(), new Integer(0) }, "Phone Number of Outside Site");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Confidentiality Code");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Observations Required to Interpret the Obs");
                                  this.add(TX.class, false, 1, 65536, new Object[]{ getMessage(), new Integer(0) }, "Interpretation of Observations");
                                  this.add(CE.class, false, 1, 65536, new Object[]{ getMessage(), new Integer(0) }, "Contraindications to Observations");
                                  this.add(CE.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Reflex Tests/Observations");
                                  this.add(TX.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Rules that Trigger Reflex Testing");
                                  this.add(CE.class, false, 1, 65536, new Object[]{ getMessage(), new Integer(0) }, "Fixed Canned Message");
                                  this.add(TX.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Patient Preparation");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Procedure Medication");
                                  this.add(TX.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Factors that may Effect the Observation");
                                  this.add(ST.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Test/Observation Performance Schedule");
                                  this.add(TX.class, false, 1, 65536, new Object[]{ getMessage(), new Integer(0) }, "Description of Test Methods");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(254) }, "Kind of Quantity Observed");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(255) }, "Point Versus Interval");
                                  this.add(TX.class, false, 1, 200, new Object[]{ getMessage(), new Integer(256) }, "Challenge Information");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(258) }, "Relationship Modifier");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Target Anatomic Site Of Test");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(259) }, "Modality Of Imaging Measurement");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OM1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OM1-1: "Sequence Number - Test/Observation Master File" - creates it if necessary
     */
    public NM getSequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-1: "Sequence Number - Test/Observation Master File" - creates it if necessary
     */
    public NM getOm11_SequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-2: "Producer's Test/Observation ID" - creates it if necessary
     */
    public CE getProducerSTestObservationID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-2: "Producer's Test/Observation ID" - creates it if necessary
     */
    public CE getOm12_ProducerSTestObservationID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Permitted Data Types (OM1-3).
     */
    public ID[] getPermittedDataTypes() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Permitted Data Types (OM1-3).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPermittedDataTypesReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-3: "Permitted Data Types" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getPermittedDataTypes(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-3: "Permitted Data Types" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getOm13_PermittedDataTypes(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Permitted Data Types (OM1-3).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm13_PermittedDataTypesReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-3: "Permitted Data Types" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertPermittedDataTypes(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-3: "Permitted Data Types" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertOm13_PermittedDataTypes(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * OM1-3: "Permitted Data Types" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removePermittedDataTypes(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * OM1-3: "Permitted Data Types" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeOm13_PermittedDataTypes(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * OM1-4: "Specimen Required" - creates it if necessary
     */
    public ID getSpecimenRequired() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-4: "Specimen Required" - creates it if necessary
     */
    public ID getOm14_SpecimenRequired() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-5: "Producer ID" - creates it if necessary
     */
    public CE getProducerID() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-5: "Producer ID" - creates it if necessary
     */
    public CE getOm15_ProducerID() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-6: "Observation Description" - creates it if necessary
     */
    public TX getObservationDescription() { 
        TX ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-6: "Observation Description" - creates it if necessary
     */
    public TX getOm16_ObservationDescription() { 
        TX ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-7: "Other Test/Observation IDs for the Observation" - creates it if necessary
     */
    public CE getOtherTestObservationIDsForTheObservation() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-7: "Other Test/Observation IDs for the Observation" - creates it if necessary
     */
    public CE getOm17_OtherTestObservationIDsForTheObservation() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Other Names (OM1-8).
     */
    public ST[] getOtherNames() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Other Names (OM1-8).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOtherNamesReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-8: "Other Names" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getOtherNames(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-8: "Other Names" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getOm18_OtherNames(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Other Names (OM1-8).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm18_OtherNamesReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-8: "Other Names" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertOtherNames(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-8: "Other Names" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertOm18_OtherNames(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * OM1-8: "Other Names" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeOtherNames(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * OM1-8: "Other Names" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeOm18_OtherNames(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * OM1-9: "Preferred Report Name for the Observation" - creates it if necessary
     */
    public ST getPreferredReportNameForTheObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-9: "Preferred Report Name for the Observation" - creates it if necessary
     */
    public ST getOm19_PreferredReportNameForTheObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-10: "Preferred Short Name or Mnemonic for Observation" - creates it if necessary
     */
    public ST getPreferredShortNameOrMnemonicForObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-10: "Preferred Short Name or Mnemonic for Observation" - creates it if necessary
     */
    public ST getOm110_PreferredShortNameOrMnemonicForObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-11: "Preferred Long Name for the Observation" - creates it if necessary
     */
    public ST getPreferredLongNameForTheObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-11: "Preferred Long Name for the Observation" - creates it if necessary
     */
    public ST getOm111_PreferredLongNameForTheObservation() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-12: "Orderability" - creates it if necessary
     */
    public ID getOrderability() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-12: "Orderability" - creates it if necessary
     */
    public ID getOm112_Orderability() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Identity of Instrument Used to Perform this Study (OM1-13).
     */
    public CE[] getIdentityOfInstrumentUsedToPerformThisStudy() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Identity of Instrument Used to Perform this Study (OM1-13).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIdentityOfInstrumentUsedToPerformThisStudyReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getIdentityOfInstrumentUsedToPerformThisStudy(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Identity of Instrument Used to Perform this Study (OM1-13).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm113_IdentityOfInstrumentUsedToPerformThisStudyReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeIdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * OM1-13: "Identity of Instrument Used to Perform this Study" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm113_IdentityOfInstrumentUsedToPerformThisStudy(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of Coded Representation of Method (OM1-14).
     */
    public CE[] getCodedRepresentationOfMethod() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Coded Representation of Method (OM1-14).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getCodedRepresentationOfMethodReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-14: "Coded Representation of Method" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCodedRepresentationOfMethod(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-14: "Coded Representation of Method" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm114_CodedRepresentationOfMethod(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Coded Representation of Method (OM1-14).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm114_CodedRepresentationOfMethodReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-14: "Coded Representation of Method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCodedRepresentationOfMethod(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-14: "Coded Representation of Method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * OM1-14: "Coded Representation of Method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCodedRepresentationOfMethod(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * OM1-14: "Coded Representation of Method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm114_CodedRepresentationOfMethod(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * OM1-15: "Portable" - creates it if necessary
     */
    public ID getPortable() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-15: "Portable" - creates it if necessary
     */
    public ID getOm115_Portable() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Observation Producing Department/Section (OM1-16).
     */
    public CE[] getObservationProducingDepartmentSection() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Observation Producing Department/Section (OM1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getObservationProducingDepartmentSectionReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-16: "Observation Producing Department/Section" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getObservationProducingDepartmentSection(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-16: "Observation Producing Department/Section" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm116_ObservationProducingDepartmentSection(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Observation Producing Department/Section (OM1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm116_ObservationProducingDepartmentSectionReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-16: "Observation Producing Department/Section" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertObservationProducingDepartmentSection(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-16: "Observation Producing Department/Section" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * OM1-16: "Observation Producing Department/Section" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeObservationProducingDepartmentSection(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * OM1-16: "Observation Producing Department/Section" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm116_ObservationProducingDepartmentSection(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * OM1-17: "Telephone Number of Section" - creates it if necessary
     */
    public XTN getTelephoneNumberOfSection() { 
        XTN ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-17: "Telephone Number of Section" - creates it if necessary
     */
    public XTN getOm117_TelephoneNumberOfSection() { 
        XTN ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-18: "Nature of Test/Observation" - creates it if necessary
     */
    public IS getNatureOfTestObservation() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-18: "Nature of Test/Observation" - creates it if necessary
     */
    public IS getOm118_NatureOfTestObservation() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-19: "Report Subheader" - creates it if necessary
     */
    public CE getReportSubheader() { 
        CE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-19: "Report Subheader" - creates it if necessary
     */
    public CE getOm119_ReportSubheader() { 
        CE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-20: "Report Display Order" - creates it if necessary
     */
    public ST getReportDisplayOrder() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-20: "Report Display Order" - creates it if necessary
     */
    public ST getOm120_ReportDisplayOrder() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-21: "Date/Time Stamp for any change in Definition for the Observation" - creates it if necessary
     */
    public TS getDateTimeStampForAnyChangeInDefinitionForTheObservation() { 
        TS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-21: "Date/Time Stamp for any change in Definition for the Observation" - creates it if necessary
     */
    public TS getOm121_DateTimeStampForAnyChangeInDefinitionForTheObservation() { 
        TS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-22: "Effective Date/Time of Change" - creates it if necessary
     */
    public TS getEffectiveDateTimeOfChange() { 
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-22: "Effective Date/Time of Change" - creates it if necessary
     */
    public TS getOm122_EffectiveDateTimeOfChange() { 
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-23: "Typical Turn-Around Time" - creates it if necessary
     */
    public NM getTypicalTurnAroundTime() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-23: "Typical Turn-Around Time" - creates it if necessary
     */
    public NM getOm123_TypicalTurnAroundTime() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-24: "Processing Time" - creates it if necessary
     */
    public NM getProcessingTime() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-24: "Processing Time" - creates it if necessary
     */
    public NM getOm124_ProcessingTime() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Processing Priority (OM1-25).
     */
    public ID[] getProcessingPriority() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(25);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Processing Priority (OM1-25).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getProcessingPriorityReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-25: "Processing Priority" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getProcessingPriority(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-25: "Processing Priority" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getOm125_ProcessingPriority(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Processing Priority (OM1-25).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm125_ProcessingPriorityReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-25: "Processing Priority" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertProcessingPriority(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(25, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-25: "Processing Priority" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertOm125_ProcessingPriority(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(25, rep);
    }


    /**
     * Removes a repetition of
     * OM1-25: "Processing Priority" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeProcessingPriority(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(25, rep);
    }


    /**
     * Removes a repetition of
     * OM1-25: "Processing Priority" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeOm125_ProcessingPriority(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(25, rep);
    }




    /**
     * Returns
     * OM1-26: "Reporting Priority" - creates it if necessary
     */
    public ID getReportingPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-26: "Reporting Priority" - creates it if necessary
     */
    public ID getOm126_ReportingPriority() { 
        ID ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Outside Site(s) Where Observation may be Performed (OM1-27).
     */
    public CE[] getOutsideSiteSWhereObservationMayBePerformed() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(27);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Outside Site(s) Where Observation may be Performed (OM1-27).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOutsideSiteSWhereObservationMayBePerformedReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOutsideSiteSWhereObservationMayBePerformed(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Outside Site(s) Where Observation may be Performed (OM1-27).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm127_OutsideSiteSWhereObservationMayBePerformedReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(27, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(27, rep);
    }


    /**
     * Removes a repetition of
     * OM1-27: "Outside Site(s) Where Observation may be Performed" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm127_OutsideSiteSWhereObservationMayBePerformed(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(27, rep);
    }



    /**
     * Returns all repetitions of Address of Outside Site(s) (OM1-28).
     */
    public XAD[] getAddressOfOutsideSiteS() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(28);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Address of Outside Site(s) (OM1-28).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getAddressOfOutsideSiteSReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-28: "Address of Outside Site(s)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getAddressOfOutsideSiteS(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-28: "Address of Outside Site(s)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getOm128_AddressOfOutsideSiteS(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Address of Outside Site(s) (OM1-28).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm128_AddressOfOutsideSiteSReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-28: "Address of Outside Site(s)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertAddressOfOutsideSiteS(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(28, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-28: "Address of Outside Site(s)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * OM1-28: "Address of Outside Site(s)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeAddressOfOutsideSiteS(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * OM1-28: "Address of Outside Site(s)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeOm128_AddressOfOutsideSiteS(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(28, rep);
    }




    /**
     * Returns
     * OM1-29: "Phone Number of Outside Site" - creates it if necessary
     */
    public XTN getPhoneNumberOfOutsideSite() { 
        XTN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-29: "Phone Number of Outside Site" - creates it if necessary
     */
    public XTN getOm129_PhoneNumberOfOutsideSite() { 
        XTN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-30: "Confidentiality Code" - creates it if necessary
     */
    public IS getConfidentialityCode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-30: "Confidentiality Code" - creates it if necessary
     */
    public IS getOm130_ConfidentialityCode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-31: "Observations Required to Interpret the Obs" - creates it if necessary
     */
    public CE getObservationsRequiredToInterpretTheObs() { 
        CE ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-31: "Observations Required to Interpret the Obs" - creates it if necessary
     */
    public CE getOm131_ObservationsRequiredToInterpretTheObs() { 
        CE ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-32: "Interpretation of Observations" - creates it if necessary
     */
    public TX getInterpretationOfObservations() { 
        TX ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-32: "Interpretation of Observations" - creates it if necessary
     */
    public TX getOm132_InterpretationOfObservations() { 
        TX ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-33: "Contraindications to Observations" - creates it if necessary
     */
    public CE getContraindicationsToObservations() { 
        CE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-33: "Contraindications to Observations" - creates it if necessary
     */
    public CE getOm133_ContraindicationsToObservations() { 
        CE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Reflex Tests/Observations (OM1-34).
     */
    public CE[] getReflexTestsObservations() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(34);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Reflex Tests/Observations (OM1-34).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getReflexTestsObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(34);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-34: "Reflex Tests/Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getReflexTestsObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-34: "Reflex Tests/Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm134_ReflexTestsObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Reflex Tests/Observations (OM1-34).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm134_ReflexTestsObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(34);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-34: "Reflex Tests/Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertReflexTestsObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(34, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-34: "Reflex Tests/Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm134_ReflexTestsObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(34, rep);
    }


    /**
     * Removes a repetition of
     * OM1-34: "Reflex Tests/Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeReflexTestsObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(34, rep);
    }


    /**
     * Removes a repetition of
     * OM1-34: "Reflex Tests/Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm134_ReflexTestsObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(34, rep);
    }




    /**
     * Returns
     * OM1-35: "Rules that Trigger Reflex Testing" - creates it if necessary
     */
    public TX getRulesThatTriggerReflexTesting() { 
        TX ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-35: "Rules that Trigger Reflex Testing" - creates it if necessary
     */
    public TX getOm135_RulesThatTriggerReflexTesting() { 
        TX ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-36: "Fixed Canned Message" - creates it if necessary
     */
    public CE getFixedCannedMessage() { 
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-36: "Fixed Canned Message" - creates it if necessary
     */
    public CE getOm136_FixedCannedMessage() { 
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-37: "Patient Preparation" - creates it if necessary
     */
    public TX getPatientPreparation() { 
        TX ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-37: "Patient Preparation" - creates it if necessary
     */
    public TX getOm137_PatientPreparation() { 
        TX ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-38: "Procedure Medication" - creates it if necessary
     */
    public CE getProcedureMedication() { 
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-38: "Procedure Medication" - creates it if necessary
     */
    public CE getOm138_ProcedureMedication() { 
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-39: "Factors that may Effect the Observation" - creates it if necessary
     */
    public TX getFactorsThatMayEffectTheObservation() { 
        TX ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-39: "Factors that may Effect the Observation" - creates it if necessary
     */
    public TX getOm139_FactorsThatMayEffectTheObservation() { 
        TX ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Test/Observation Performance Schedule (OM1-40).
     */
    public ST[] getTestObservationPerformanceSchedule() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(40);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Test/Observation Performance Schedule (OM1-40).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getTestObservationPerformanceScheduleReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(40);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM1-40: "Test/Observation Performance Schedule" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getTestObservationPerformanceSchedule(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(40, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM1-40: "Test/Observation Performance Schedule" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getOm140_TestObservationPerformanceSchedule(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(40, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Test/Observation Performance Schedule (OM1-40).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm140_TestObservationPerformanceScheduleReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(40);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM1-40: "Test/Observation Performance Schedule" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertTestObservationPerformanceSchedule(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(40, rep);
    }



    /**
     * Inserts a repetition of
     * OM1-40: "Test/Observation Performance Schedule" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertOm140_TestObservationPerformanceSchedule(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(40, rep);
    }


    /**
     * Removes a repetition of
     * OM1-40: "Test/Observation Performance Schedule" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeTestObservationPerformanceSchedule(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(40, rep);
    }


    /**
     * Removes a repetition of
     * OM1-40: "Test/Observation Performance Schedule" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeOm140_TestObservationPerformanceSchedule(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(40, rep);
    }




    /**
     * Returns
     * OM1-41: "Description of Test Methods" - creates it if necessary
     */
    public TX getDescriptionOfTestMethods() { 
        TX ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-41: "Description of Test Methods" - creates it if necessary
     */
    public TX getOm141_DescriptionOfTestMethods() { 
        TX ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-42: "Kind of Quantity Observed" - creates it if necessary
     */
    public CE getKindOfQuantityObserved() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-42: "Kind of Quantity Observed" - creates it if necessary
     */
    public CE getOm142_KindOfQuantityObserved() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-43: "Point Versus Interval" - creates it if necessary
     */
    public CE getPointVersusInterval() { 
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-43: "Point Versus Interval" - creates it if necessary
     */
    public CE getOm143_PointVersusInterval() { 
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-44: "Challenge Information" - creates it if necessary
     */
    public TX getChallengeInformation() { 
        TX ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-44: "Challenge Information" - creates it if necessary
     */
    public TX getOm144_ChallengeInformation() { 
        TX ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-45: "Relationship Modifier" - creates it if necessary
     */
    public CE getRelationshipModifier() { 
        CE ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-45: "Relationship Modifier" - creates it if necessary
     */
    public CE getOm145_RelationshipModifier() { 
        CE ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-46: "Target Anatomic Site Of Test" - creates it if necessary
     */
    public CE getTargetAnatomicSiteOfTest() { 
        CE ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-46: "Target Anatomic Site Of Test" - creates it if necessary
     */
    public CE getOm146_TargetAnatomicSiteOfTest() { 
        CE ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM1-47: "Modality Of Imaging Measurement" - creates it if necessary
     */
    public CE getModalityOfImagingMeasurement() { 
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM1-47: "Modality Of Imaging Measurement" - creates it if necessary
     */
    public CE getOm147_ModalityOfImagingMeasurement() { 
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new NM(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new ID(getMessage(), new Integer( 125 ));
          case 3: return new ID(getMessage(), new Integer( 136 ));
          case 4: return new CE(getMessage());
          case 5: return new TX(getMessage());
          case 6: return new CE(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new ST(getMessage());
          case 10: return new ST(getMessage());
          case 11: return new ID(getMessage(), new Integer( 136 ));
          case 12: return new CE(getMessage());
          case 13: return new CE(getMessage());
          case 14: return new ID(getMessage(), new Integer( 136 ));
          case 15: return new CE(getMessage());
          case 16: return new XTN(getMessage());
          case 17: return new IS(getMessage(), new Integer( 174 ));
          case 18: return new CE(getMessage());
          case 19: return new ST(getMessage());
          case 20: return new TS(getMessage());
          case 21: return new TS(getMessage());
          case 22: return new NM(getMessage());
          case 23: return new NM(getMessage());
          case 24: return new ID(getMessage(), new Integer( 168 ));
          case 25: return new ID(getMessage(), new Integer( 169 ));
          case 26: return new CE(getMessage());
          case 27: return new XAD(getMessage());
          case 28: return new XTN(getMessage());
          case 29: return new IS(getMessage(), new Integer( 177 ));
          case 30: return new CE(getMessage());
          case 31: return new TX(getMessage());
          case 32: return new CE(getMessage());
          case 33: return new CE(getMessage());
          case 34: return new TX(getMessage());
          case 35: return new CE(getMessage());
          case 36: return new TX(getMessage());
          case 37: return new CE(getMessage());
          case 38: return new TX(getMessage());
          case 39: return new ST(getMessage());
          case 40: return new TX(getMessage());
          case 41: return new CE(getMessage());
          case 42: return new CE(getMessage());
          case 43: return new TX(getMessage());
          case 44: return new CE(getMessage());
          case 45: return new CE(getMessage());
          case 46: return new CE(getMessage());
          default: return null;
       }
   }


}

