/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.segment;

// import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PRB message segment (Problem Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PRB-1: Action Code (ID) <b> </b>
     * <li>PRB-2: Action Date/Time (TS) <b> </b>
     * <li>PRB-3: Problem ID (CE) <b> </b>
     * <li>PRB-4: Problem Instance ID (EI) <b> </b>
     * <li>PRB-5: Episode of Care ID (EI) <b>optional </b>
     * <li>PRB-6: Problem List Priority (NM) <b>optional </b>
     * <li>PRB-7: Problem Established Date/Time (TS) <b>optional </b>
     * <li>PRB-8: Anticipated Problem Resolution Date/Time (TS) <b>optional </b>
     * <li>PRB-9: Actual Problem Resolution Date/Time (TS) <b>optional </b>
     * <li>PRB-10: Problem Classification (CE) <b>optional </b>
     * <li>PRB-11: Problem Management Discipline (CE) <b>optional repeating</b>
     * <li>PRB-12: Problem Persistence (CE) <b>optional </b>
     * <li>PRB-13: Problem Confirmation Status (CE) <b>optional </b>
     * <li>PRB-14: Problem Life Cycle Status (CE) <b>optional </b>
     * <li>PRB-15: Problem Life Cycle Status Date/Time (TS) <b>optional </b>
     * <li>PRB-16: Problem Date of Onset (TS) <b>optional </b>
     * <li>PRB-17: Problem Onset Text (ST) <b>optional </b>
     * <li>PRB-18: Problem Ranking (CE) <b>optional </b>
     * <li>PRB-19: Certainty of Problem (CE) <b>optional </b>
     * <li>PRB-20: Probability of Problem (0-1) (NM) <b>optional </b>
     * <li>PRB-21: Individual Awareness of Problem (CE) <b>optional </b>
     * <li>PRB-22: Problem Prognosis (CE) <b>optional </b>
     * <li>PRB-23: Individual Awareness of Prognosis (CE) <b>optional </b>
     * <li>PRB-24: Family/Significant Other Awareness of Problem/Prognosis (ST) <b>optional </b>
     * <li>PRB-25: Security/Sensitivity (CE) <b>optional </b>
 * </ul>
 */
public class PRB extends AbstractSegment {

    /** 
     * Creates a new PRB segment
     */
    public PRB(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Action Code");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Action Date/Time");
                                  this.add(CE.class, true, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem ID");
                                  this.add(EI.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Problem Instance ID");
                                  this.add(EI.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Episode of Care ID");
                                  this.add(NM.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Problem List Priority");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Problem Established Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Anticipated Problem Resolution Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Actual Problem Resolution Date/Time");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Classification");
                                  this.add(CE.class, false, 0, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Management Discipline");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Persistence");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Confirmation Status");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Life Cycle Status");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Problem Life Cycle Status Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Problem Date of Onset");
                                  this.add(ST.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Onset Text");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Ranking");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Certainty of Problem");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Probability of Problem (0-1)");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Individual Awareness of Problem");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Problem Prognosis");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Individual Awareness of Prognosis");
                                  this.add(ST.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Family/Significant Other Awareness of Problem/Prognosis");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Security/Sensitivity");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRB - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PRB-1: "Action Code" - creates it if necessary
     */
    public ID getActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-1: "Action Code" - creates it if necessary
     */
    public ID getPrb1_ActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-2: "Action Date/Time" - creates it if necessary
     */
    public TS getActionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-2: "Action Date/Time" - creates it if necessary
     */
    public TS getPrb2_ActionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-3: "Problem ID" - creates it if necessary
     */
    public CE getProblemID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-3: "Problem ID" - creates it if necessary
     */
    public CE getPrb3_ProblemID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-4: "Problem Instance ID" - creates it if necessary
     */
    public EI getProblemInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-4: "Problem Instance ID" - creates it if necessary
     */
    public EI getPrb4_ProblemInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-5: "Episode of Care ID" - creates it if necessary
     */
    public EI getEpisodeOfCareID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-5: "Episode of Care ID" - creates it if necessary
     */
    public EI getPrb5_EpisodeOfCareID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-6: "Problem List Priority" - creates it if necessary
     */
    public NM getProblemListPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-6: "Problem List Priority" - creates it if necessary
     */
    public NM getPrb6_ProblemListPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-7: "Problem Established Date/Time" - creates it if necessary
     */
    public TS getProblemEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-7: "Problem Established Date/Time" - creates it if necessary
     */
    public TS getPrb7_ProblemEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-8: "Anticipated Problem Resolution Date/Time" - creates it if necessary
     */
    public TS getAnticipatedProblemResolutionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-8: "Anticipated Problem Resolution Date/Time" - creates it if necessary
     */
    public TS getPrb8_AnticipatedProblemResolutionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-9: "Actual Problem Resolution Date/Time" - creates it if necessary
     */
    public TS getActualProblemResolutionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-9: "Actual Problem Resolution Date/Time" - creates it if necessary
     */
    public TS getPrb9_ActualProblemResolutionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-10: "Problem Classification" - creates it if necessary
     */
    public CE getProblemClassification() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-10: "Problem Classification" - creates it if necessary
     */
    public CE getPrb10_ProblemClassification() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Problem Management Discipline (PRB-11).
     */
    public CE[] getProblemManagementDiscipline() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Problem Management Discipline (PRB-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getProblemManagementDisciplineReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PRB-11: "Problem Management Discipline" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getProblemManagementDiscipline(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRB-11: "Problem Management Discipline" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPrb11_ProblemManagementDiscipline(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Problem Management Discipline (PRB-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPrb11_ProblemManagementDisciplineReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PRB-11: "Problem Management Discipline" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertProblemManagementDiscipline(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * PRB-11: "Problem Management Discipline" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPrb11_ProblemManagementDiscipline(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRB-11: "Problem Management Discipline" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeProblemManagementDiscipline(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRB-11: "Problem Management Discipline" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePrb11_ProblemManagementDiscipline(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * PRB-12: "Problem Persistence" - creates it if necessary
     */
    public CE getProblemPersistence() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-12: "Problem Persistence" - creates it if necessary
     */
    public CE getPrb12_ProblemPersistence() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-13: "Problem Confirmation Status" - creates it if necessary
     */
    public CE getProblemConfirmationStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-13: "Problem Confirmation Status" - creates it if necessary
     */
    public CE getPrb13_ProblemConfirmationStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-14: "Problem Life Cycle Status" - creates it if necessary
     */
    public CE getProblemLifeCycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-14: "Problem Life Cycle Status" - creates it if necessary
     */
    public CE getPrb14_ProblemLifeCycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-15: "Problem Life Cycle Status Date/Time" - creates it if necessary
     */
    public TS getProblemLifeCycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-15: "Problem Life Cycle Status Date/Time" - creates it if necessary
     */
    public TS getPrb15_ProblemLifeCycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-16: "Problem Date of Onset" - creates it if necessary
     */
    public TS getProblemDateOfOnset() { 
        TS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-16: "Problem Date of Onset" - creates it if necessary
     */
    public TS getPrb16_ProblemDateOfOnset() { 
        TS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-17: "Problem Onset Text" - creates it if necessary
     */
    public ST getProblemOnsetText() { 
        ST ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-17: "Problem Onset Text" - creates it if necessary
     */
    public ST getPrb17_ProblemOnsetText() { 
        ST ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-18: "Problem Ranking" - creates it if necessary
     */
    public CE getProblemRanking() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-18: "Problem Ranking" - creates it if necessary
     */
    public CE getPrb18_ProblemRanking() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-19: "Certainty of Problem" - creates it if necessary
     */
    public CE getCertaintyOfProblem() { 
        CE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-19: "Certainty of Problem" - creates it if necessary
     */
    public CE getPrb19_CertaintyOfProblem() { 
        CE ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-20: "Probability of Problem (0-1)" - creates it if necessary
     */
    public NM getProbabilityOfProblem() { 
        NM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-20: "Probability of Problem (0-1)" - creates it if necessary
     */
    public NM getPrb20_ProbabilityOfProblem() { 
        NM ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-21: "Individual Awareness of Problem" - creates it if necessary
     */
    public CE getIndividualAwarenessOfProblem() { 
        CE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-21: "Individual Awareness of Problem" - creates it if necessary
     */
    public CE getPrb21_IndividualAwarenessOfProblem() { 
        CE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-22: "Problem Prognosis" - creates it if necessary
     */
    public CE getProblemPrognosis() { 
        CE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-22: "Problem Prognosis" - creates it if necessary
     */
    public CE getPrb22_ProblemPrognosis() { 
        CE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-23: "Individual Awareness of Prognosis" - creates it if necessary
     */
    public CE getIndividualAwarenessOfPrognosis() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-23: "Individual Awareness of Prognosis" - creates it if necessary
     */
    public CE getPrb23_IndividualAwarenessOfPrognosis() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-24: "Family/Significant Other Awareness of Problem/Prognosis" - creates it if necessary
     */
    public ST getFamilySignificantOtherAwarenessOfProblemPrognosis() { 
        ST ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-24: "Family/Significant Other Awareness of Problem/Prognosis" - creates it if necessary
     */
    public ST getPrb24_FamilySignificantOtherAwarenessOfProblemPrognosis() { 
        ST ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRB-25: "Security/Sensitivity" - creates it if necessary
     */
    public CE getSecuritySensitivity() { 
        CE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRB-25: "Security/Sensitivity" - creates it if necessary
     */
    public CE getPrb25_SecuritySensitivity() { 
        CE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 287 ));
          case 1: return new TS(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new NM(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new TS(getMessage());
          case 8: return new TS(getMessage());
          case 9: return new CE(getMessage());
          case 10: return new CE(getMessage());
          case 11: return new CE(getMessage());
          case 12: return new CE(getMessage());
          case 13: return new CE(getMessage());
          case 14: return new TS(getMessage());
          case 15: return new TS(getMessage());
          case 16: return new ST(getMessage());
          case 17: return new CE(getMessage());
          case 18: return new CE(getMessage());
          case 19: return new NM(getMessage());
          case 20: return new CE(getMessage());
          case 21: return new CE(getMessage());
          case 22: return new CE(getMessage());
          case 23: return new ST(getMessage());
          case 24: return new CE(getMessage());
          default: return null;
       }
   }


}

