/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.segment;

// import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PSH message segment (PSH - product summary header segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PSH-1: Report Type (ST) <b> </b>
     * <li>PSH-2: Report Form Identifier (ST) <b>optional </b>
     * <li>PSH-3: Report Date (TS) <b> </b>
     * <li>PSH-4: Report Interval Start Date (TS) <b>optional </b>
     * <li>PSH-5: Report Interval End Date (TS) <b>optional </b>
     * <li>PSH-6: Quantity Manufactured (CQ) <b>optional </b>
     * <li>PSH-7: Quantity Distributed (CQ) <b>optional </b>
     * <li>PSH-8: Quantity Distributed Method (ID) <b>optional </b>
     * <li>PSH-9: Quantity Distributed Comment (FT) <b>optional </b>
     * <li>PSH-10: Quantity in Use (CQ) <b>optional </b>
     * <li>PSH-11: Quantity in Use Method (ID) <b>optional </b>
     * <li>PSH-12: Quantity in Use Comment (FT) <b>optional </b>
     * <li>PSH-13: Number of Product Experience Reports Filed by Facility (NM) <b>optional repeating</b>
     * <li>PSH-14: Number of Product Experience Reports Filed by Distributor (NM) <b>optional repeating</b>
 * </ul>
 */
public class PSH extends AbstractSegment {

    /** 
     * Creates a new PSH segment
     */
    public PSH(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Report Type");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Report Form Identifier");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Report Date");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Report Interval Start Date");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Report Interval End Date");
                                  this.add(CQ.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Quantity Manufactured");
                                  this.add(CQ.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Quantity Distributed");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Quantity Distributed Method");
                                  this.add(FT.class, false, 1, 600, new Object[]{ getMessage(), new Integer(0) }, "Quantity Distributed Comment");
                                  this.add(CQ.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Quantity in Use");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Quantity in Use Method");
                                  this.add(FT.class, false, 1, 600, new Object[]{ getMessage(), new Integer(0) }, "Quantity in Use Comment");
                                  this.add(NM.class, false, 8, 2, new Object[]{ getMessage(), new Integer(0) }, "Number of Product Experience Reports Filed by Facility");
                                  this.add(NM.class, false, 8, 2, new Object[]{ getMessage(), new Integer(0) }, "Number of Product Experience Reports Filed by Distributor");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PSH - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PSH-1: "Report Type" - creates it if necessary
     */
    public ST getReportType() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-1: "Report Type" - creates it if necessary
     */
    public ST getPsh1_ReportType() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-2: "Report Form Identifier" - creates it if necessary
     */
    public ST getReportFormIdentifier() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-2: "Report Form Identifier" - creates it if necessary
     */
    public ST getPsh2_ReportFormIdentifier() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-3: "Report Date" - creates it if necessary
     */
    public TS getReportDate() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-3: "Report Date" - creates it if necessary
     */
    public TS getPsh3_ReportDate() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-4: "Report Interval Start Date" - creates it if necessary
     */
    public TS getReportIntervalStartDate() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-4: "Report Interval Start Date" - creates it if necessary
     */
    public TS getPsh4_ReportIntervalStartDate() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-5: "Report Interval End Date" - creates it if necessary
     */
    public TS getReportIntervalEndDate() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-5: "Report Interval End Date" - creates it if necessary
     */
    public TS getPsh5_ReportIntervalEndDate() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-6: "Quantity Manufactured" - creates it if necessary
     */
    public CQ getQuantityManufactured() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-6: "Quantity Manufactured" - creates it if necessary
     */
    public CQ getPsh6_QuantityManufactured() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-7: "Quantity Distributed" - creates it if necessary
     */
    public CQ getQuantityDistributed() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-7: "Quantity Distributed" - creates it if necessary
     */
    public CQ getPsh7_QuantityDistributed() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-8: "Quantity Distributed Method" - creates it if necessary
     */
    public ID getQuantityDistributedMethod() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-8: "Quantity Distributed Method" - creates it if necessary
     */
    public ID getPsh8_QuantityDistributedMethod() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-9: "Quantity Distributed Comment" - creates it if necessary
     */
    public FT getQuantityDistributedComment() { 
        FT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-9: "Quantity Distributed Comment" - creates it if necessary
     */
    public FT getPsh9_QuantityDistributedComment() { 
        FT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-10: "Quantity in Use" - creates it if necessary
     */
    public CQ getQuantityInUse() { 
        CQ ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-10: "Quantity in Use" - creates it if necessary
     */
    public CQ getPsh10_QuantityInUse() { 
        CQ ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-11: "Quantity in Use Method" - creates it if necessary
     */
    public ID getQuantityInUseMethod() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-11: "Quantity in Use Method" - creates it if necessary
     */
    public ID getPsh11_QuantityInUseMethod() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSH-12: "Quantity in Use Comment" - creates it if necessary
     */
    public FT getQuantityInUseComment() { 
        FT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSH-12: "Quantity in Use Comment" - creates it if necessary
     */
    public FT getPsh12_QuantityInUseComment() { 
        FT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Number of Product Experience Reports Filed by Facility (PSH-13).
     */
    public NM[] getNumberOfProductExperienceReportsFiledByFacility() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (NM)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Number of Product Experience Reports Filed by Facility (PSH-13).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getNumberOfProductExperienceReportsFiledByFacilityReps() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public NM getNumberOfProductExperienceReportsFiledByFacility(int rep) { 
        NM ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public NM getPsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) { 
        NM ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Number of Product Experience Reports Filed by Facility (PSH-13).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPsh13_NumberOfProductExperienceReportsFiledByFacilityReps() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM insertNumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception { 
        return (NM) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM insertPsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception { 
        return (NM) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM removeNumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception { 
        return (NM) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PSH-13: "Number of Product Experience Reports Filed by Facility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM removePsh13_NumberOfProductExperienceReportsFiledByFacility(int rep) throws HL7Exception { 
        return (NM) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of Number of Product Experience Reports Filed by Distributor (PSH-14).
     */
    public NM[] getNumberOfProductExperienceReportsFiledByDistributor() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (NM)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Number of Product Experience Reports Filed by Distributor (PSH-14).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getNumberOfProductExperienceReportsFiledByDistributorReps() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public NM getNumberOfProductExperienceReportsFiledByDistributor(int rep) { 
        NM ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public NM getPsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) { 
        NM ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Number of Product Experience Reports Filed by Distributor (PSH-14).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPsh14_NumberOfProductExperienceReportsFiledByDistributorReps() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM insertNumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception { 
        return (NM) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM insertPsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception { 
        return (NM) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM removeNumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception { 
        return (NM) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PSH-14: "Number of Product Experience Reports Filed by Distributor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public NM removePsh14_NumberOfProductExperienceReportsFiledByDistributor(int rep) throws HL7Exception { 
        return (NM) super.removeRepetition(14, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new TS(getMessage());
          case 3: return new TS(getMessage());
          case 4: return new TS(getMessage());
          case 5: return new CQ(getMessage());
          case 6: return new CQ(getMessage());
          case 7: return new ID(getMessage(), new Integer( 329 ));
          case 8: return new FT(getMessage());
          case 9: return new CQ(getMessage());
          case 10: return new ID(getMessage(), new Integer( 329 ));
          case 11: return new FT(getMessage());
          case 12: return new NM(getMessage());
          case 13: return new NM(getMessage());
          default: return null;
       }
   }


}

