/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v231.segment;

// import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RDF message segment (RDF - table row definition segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RDF-1: Number of Columns per Row (NM) <b> </b>
     * <li>RDF-2: Column Description (RCD) <b> repeating</b>
 * </ul>
 */
public class RDF extends AbstractSegment {

    /** 
     * Creates a new RDF segment
     */
    public RDF(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(NM.class, true, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Number of Columns per Row");
                                  this.add(RCD.class, true, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Column Description");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDF - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * RDF-1: "Number of Columns per Row" - creates it if necessary
     */
    public NM getNumberOfColumnsPerRow() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RDF-1: "Number of Columns per Row" - creates it if necessary
     */
    public NM getRdf1_NumberOfColumnsPerRow() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Column Description (RDF-2).
     */
    public RCD[] getColumnDescription() {
        RCD[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new RCD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (RCD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Column Description (RDF-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getColumnDescriptionReps() {
        RCD[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RDF-2: "Column Description" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public RCD getColumnDescription(int rep) { 
        RCD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (RCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RDF-2: "Column Description" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public RCD getRdf2_ColumnDescription(int rep) { 
        RCD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (RCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Column Description (RDF-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRdf2_ColumnDescriptionReps() {
        RCD[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RDF-2: "Column Description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public RCD insertColumnDescription(int rep) throws HL7Exception { 
        return (RCD) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * RDF-2: "Column Description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public RCD insertRdf2_ColumnDescription(int rep) throws HL7Exception { 
        return (RCD) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * RDF-2: "Column Description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public RCD removeColumnDescription(int rep) throws HL7Exception { 
        return (RCD) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * RDF-2: "Column Description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public RCD removeRdf2_ColumnDescription(int rep) throws HL7Exception { 
        return (RCD) super.removeRepetition(2, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new NM(getMessage());
          case 1: return new RCD(getMessage());
          default: return null;
       }
   }


}

