/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.ADT_A44_PIDPD1MRG;
import ca.uhn.hl7v2.model.v231.segment.EVN;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ADT_A44
extends AbstractMessage {
    public ADT_A44() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A44(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(ADT_A44_PIDPD1MRG.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating ADT_A44 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A44_PIDPD1MRG getPIDPD1MRG() {
        ADT_A44_PIDPD1MRG ret = null;
        try {
            ret = (ADT_A44_PIDPD1MRG)this.get("PIDPD1MRG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A44_PIDPD1MRG getPIDPD1MRG(int rep) {
        ADT_A44_PIDPD1MRG ret = null;
        try {
            ret = (ADT_A44_PIDPD1MRG)this.get("PIDPD1MRG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPIDPD1MRGReps() {
        int reps = -1;
        try {
            reps = this.getAll("PIDPD1MRG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPIDPD1MRG(ADT_A44_PIDPD1MRG structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPD1MRG", (Structure)structure, rep);
    }

    public ADT_A44_PIDPD1MRG insertPIDPD1MRG(int rep) throws HL7Exception {
        return (ADT_A44_PIDPD1MRG)super.insertRepetition("PIDPD1MRG", rep);
    }

    public ADT_A44_PIDPD1MRG removePIDPD1MRG(int rep) throws HL7Exception {
        return (ADT_A44_PIDPD1MRG)super.removeRepetition("PIDPD1MRG", rep);
    }
}

