/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_ORCODSNTEOBXNTE;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_ORCODTNTE;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMD_O01
extends AbstractMessage {
    public OMD_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OMD_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(OMD_O01_ORCODSNTEOBXNTE.class, true, true);
            this.add(OMD_O01_ORCODTNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OMD_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
        try {
            ret = (OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE() {
        OMD_O01_ORCODSNTEOBXNTE ret = null;
        try {
            ret = (OMD_O01_ORCODSNTEOBXNTE)this.get("ORCODSNTEOBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE(int rep) {
        OMD_O01_ORCODSNTEOBXNTE ret = null;
        try {
            ret = (OMD_O01_ORCODSNTEOBXNTE)this.get("ORCODSNTEOBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCODSNTEOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCODSNTEOBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCODSNTEOBXNTE(OMD_O01_ORCODSNTEOBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCODSNTEOBXNTE", (Structure)structure, rep);
    }

    public OMD_O01_ORCODSNTEOBXNTE insertORCODSNTEOBXNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODSNTEOBXNTE)super.insertRepetition("ORCODSNTEOBXNTE", rep);
    }

    public OMD_O01_ORCODSNTEOBXNTE removeORCODSNTEOBXNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODSNTEOBXNTE)super.removeRepetition("ORCODSNTEOBXNTE", rep);
    }

    public OMD_O01_ORCODTNTE getORCODTNTE() {
        OMD_O01_ORCODTNTE ret = null;
        try {
            ret = (OMD_O01_ORCODTNTE)this.get("ORCODTNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMD_O01_ORCODTNTE getORCODTNTE(int rep) {
        OMD_O01_ORCODTNTE ret = null;
        try {
            ret = (OMD_O01_ORCODTNTE)this.get("ORCODTNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCODTNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCODTNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCODTNTE(OMD_O01_ORCODTNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCODTNTE", (Structure)structure, rep);
    }

    public OMD_O01_ORCODTNTE insertORCODTNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODTNTE)super.insertRepetition("ORCODTNTE", rep);
    }

    public OMD_O01_ORCODTNTE removeORCODTNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODTNTE)super.removeRepetition("ORCODTNTE", rep);
    }
}

