/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.OMN_O01_ORCRQDRQ1NTEOBXNTEBLG;
import ca.uhn.hl7v2.model.v231.group.OMN_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMN_O01
extends AbstractMessage {
    public OMN_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OMN_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMN_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(OMN_O01_ORCRQDRQ1NTEOBXNTEBLG.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OMN_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMN_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        OMN_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
        try {
            ret = (OMN_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMN_O01_ORCRQDRQ1NTEOBXNTEBLG getORCRQDRQ1NTEOBXNTEBLG() {
        OMN_O01_ORCRQDRQ1NTEOBXNTEBLG ret = null;
        try {
            ret = (OMN_O01_ORCRQDRQ1NTEOBXNTEBLG)this.get("ORCRQDRQ1NTEOBXNTEBLG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMN_O01_ORCRQDRQ1NTEOBXNTEBLG getORCRQDRQ1NTEOBXNTEBLG(int rep) {
        OMN_O01_ORCRQDRQ1NTEOBXNTEBLG ret = null;
        try {
            ret = (OMN_O01_ORCRQDRQ1NTEOBXNTEBLG)this.get("ORCRQDRQ1NTEOBXNTEBLG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRQDRQ1NTEOBXNTEBLGReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRQDRQ1NTEOBXNTEBLG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRQDRQ1NTEOBXNTEBLG(OMN_O01_ORCRQDRQ1NTEOBXNTEBLG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRQDRQ1NTEOBXNTEBLG", (Structure)structure, rep);
    }

    public OMN_O01_ORCRQDRQ1NTEOBXNTEBLG insertORCRQDRQ1NTEOBXNTEBLG(int rep) throws HL7Exception {
        return (OMN_O01_ORCRQDRQ1NTEOBXNTEBLG)super.insertRepetition("ORCRQDRQ1NTEOBXNTEBLG", rep);
    }

    public OMN_O01_ORCRQDRQ1NTEOBXNTEBLG removeORCRQDRQ1NTEOBXNTEBLG(int rep) throws HL7Exception {
        return (OMN_O01_ORCRQDRQ1NTEOBXNTEBLG)super.removeRepetition("ORCRQDRQ1NTEOBXNTEBLG", rep);
    }
}

