/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI;
import ca.uhn.hl7v2.model.v231.group.RDE_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RDE_O01
extends AbstractMessage {
    public RDE_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RDE_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RDE_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating RDE_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RDE_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        RDE_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
        try {
            ret = (RDE_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI getORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI() {
        RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI ret = null;
        try {
            ret = (RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI)this.get("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI getORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI(int rep) {
        RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI ret = null;
        try {
            ret = (RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI)this.get("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXONTERXRRXCNTERXERXRRXCOBXNTECTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI(RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI", (Structure)structure, rep);
    }

    public RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI insertORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI(int rep) throws HL7Exception {
        return (RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI)super.insertRepetition("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI", rep);
    }

    public RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI removeORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI(int rep) throws HL7Exception {
        return (RDE_O01_ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI)super.removeRepetition("ORCRXONTERXRRXCNTERXERXRRXCOBXNTECTI", rep);
    }
}

