/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC;
import ca.uhn.hl7v2.model.v231.segment.DSC;
import ca.uhn.hl7v2.model.v231.segment.ERR;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDR_RDR
extends AbstractMessage {
    public RDR_RDR() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RDR_RDR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RDR_RDR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MSA getMSA() {
        MSA ret = null;
        try {
            ret = (MSA)this.get("MSA");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ERR getERR() {
        ERR ret = null;
        try {
            ret = (ERR)this.get("ERR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC getQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC() {
        RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC ret = null;
        try {
            ret = (RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC)this.get("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC getQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC(int rep) {
        RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC ret = null;
        try {
            ret = (RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC)this.get("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXCReps() {
        int reps = -1;
        try {
            reps = this.getAll("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC> getQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXCAll() throws HL7Exception {
        return this.getAllAsList("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC", RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC.class);
    }

    public void insertQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC(RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC structure, int rep) throws HL7Exception {
        super.insertRepetition("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC", (Structure)structure, rep);
    }

    public RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC insertQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC(int rep) throws HL7Exception {
        return (RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC)super.insertRepetition("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC", rep);
    }

    public RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC removeQRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC(int rep) throws HL7Exception {
        return (RDR_RDR_QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC)super.removeRepetition("QRDQRFPIDNTEORCRXERXRRXCRXDRXRRXC", rep);
    }

    public DSC getDSC() {
        DSC ret = null;
        try {
            ret = (DSC)this.get("DSC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

