/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_ORCRXARXROBXNTE;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v231.segment.QRD;
import ca.uhn.hl7v2.model.v231.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXR_V03
extends AbstractMessage {
    public VXR_V03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public VXR_V03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXR_V03_PV1PV2.class, false, false);
            this.add(VXR_V03_IN1IN2IN3.class, false, true);
            this.add(VXR_V03_ORCRXARXROBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VXR_V03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXR_V03_PV1PV2 getPV1PV2() {
        return (VXR_V03_PV1PV2)this.getTyped("PV1PV2", VXR_V03_PV1PV2.class);
    }

    public VXR_V03_IN1IN2IN3 getIN1IN2IN3() {
        return (VXR_V03_IN1IN2IN3)this.getTyped("IN1IN2IN3", VXR_V03_IN1IN2IN3.class);
    }

    public VXR_V03_IN1IN2IN3 getIN1IN2IN3(int rep) {
        return (VXR_V03_IN1IN2IN3)this.getTyped("IN1IN2IN3", rep, VXR_V03_IN1IN2IN3.class);
    }

    public int getIN1IN2IN3Reps() {
        return this.getReps("IN1IN2IN3");
    }

    public List<VXR_V03_IN1IN2IN3> getIN1IN2IN3All() throws HL7Exception {
        return this.getAllAsList("IN1IN2IN3", VXR_V03_IN1IN2IN3.class);
    }

    public void insertIN1IN2IN3(VXR_V03_IN1IN2IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1IN2IN3", (Structure)structure, rep);
    }

    public VXR_V03_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception {
        return (VXR_V03_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }

    public VXR_V03_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception {
        return (VXR_V03_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }

    public VXR_V03_ORCRXARXROBXNTE getORCRXARXROBXNTE() {
        return (VXR_V03_ORCRXARXROBXNTE)this.getTyped("ORCRXARXROBXNTE", VXR_V03_ORCRXARXROBXNTE.class);
    }

    public VXR_V03_ORCRXARXROBXNTE getORCRXARXROBXNTE(int rep) {
        return (VXR_V03_ORCRXARXROBXNTE)this.getTyped("ORCRXARXROBXNTE", rep, VXR_V03_ORCRXARXROBXNTE.class);
    }

    public int getORCRXARXROBXNTEReps() {
        return this.getReps("ORCRXARXROBXNTE");
    }

    public List<VXR_V03_ORCRXARXROBXNTE> getORCRXARXROBXNTEAll() throws HL7Exception {
        return this.getAllAsList("ORCRXARXROBXNTE", VXR_V03_ORCRXARXROBXNTE.class);
    }

    public void insertORCRXARXROBXNTE(VXR_V03_ORCRXARXROBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXARXROBXNTE", (Structure)structure, rep);
    }

    public VXR_V03_ORCRXARXROBXNTE insertORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_ORCRXARXROBXNTE)super.insertRepetition("ORCRXARXROBXNTE", rep);
    }

    public VXR_V03_ORCRXARXROBXNTE removeORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_ORCRXARXROBXNTE)super.removeRepetition("ORCRXARXROBXNTE", rep);
    }
}

