/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CF (coded element with formatted values) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>identifier (ID) (ID)
 * <li>formatted text (FT)
 * <li>name of coding system (IS)
 * <li>alternate identifier (ID) (ID)
 * <li>alternate formatted text (FT)
 * <li>name of alternate coding system (IS)
 * </ul>
 */
public class CF extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CF type
     */
    public CF(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new FT(getMessage());
        data[2] = new IS(getMessage(), 0);
        data[3] = new ID(getMessage(), 0);
        data[4] = new FT(getMessage());
        data[5] = new IS(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns identifier (ID) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns identifier (ID) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCf1_Identifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns formatted text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns formatted text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getCf2_FormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns name of coding system (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNameOfCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns name of coding system (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCf3_NameOfCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate identifier (ID) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getAlternateIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate identifier (ID) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCf4_AlternateIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns alternate formatted text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getAlternateFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns alternate formatted text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getCf5_AlternateFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns name of alternate coding system (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getNameOfAlternateCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns name of alternate coding system (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCf6_NameOfAlternateCodingSystem() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

