/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 PCF (Pre-certification required) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>pre-certification patient type (IS)
 * <li>pre-certification required (ID)
 * <li>pre-certification window (TS)
 * </ul>
 */
public class PCF extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new PCF type
     */
    public PCF(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new IS(getMessage(), 0);
        data[1] = new ID(getMessage(), 0);
        data[2] = new TS(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns pre-certification patient type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPreCertificationPatientType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns pre-certification patient type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPcf1_PreCertificationPatientType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns pre-certification required (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getPreCertificationRequired() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns pre-certification required (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getPcf2_PreCertificationRequired() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns pre-certification window (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getPreCertificationWindow() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns pre-certification window (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getPcf3_PreCertificationWindow() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

