/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a PEX_P07_PEX_CAUSE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PCR (Possible Causal Relationship) <b> </b></li>
                 * <li>2: PEX_P07_RX_ORDER (a Group object) <b>optional </b></li>
                 * <li>3: PEX_P07_RX_ADMINISTRATION (a Group object) <b>optional repeating</b></li>
                 * <li>4: PRB (Problem Details) <b>optional repeating</b></li>
                 * <li>5: OBX (Observation/Result) <b>optional repeating</b></li>
                 * <li>6: NTE (Notes and Comments) <b>optional repeating</b></li>
                 * <li>7: PEX_P07_ASSOCIATED_PERSON (a Group object) <b>optional </b></li>
                 * <li>8: PEX_P07_STUDY (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class PEX_P07_PEX_CAUSE extends AbstractGroup {

    /** 
     * Creates a new PEX_P07_PEX_CAUSE group
     */
    public PEX_P07_PEX_CAUSE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PCR.class, true, false);
                          this.add(PEX_P07_RX_ORDER.class, false, false);
                          this.add(PEX_P07_RX_ADMINISTRATION.class, false, true);
                          this.add(PRB.class, false, true);
                          this.add(OBX.class, false, true);
                          this.add(NTE.class, false, true);
                          this.add(PEX_P07_ASSOCIATED_PERSON.class, false, false);
                          this.add(PEX_P07_STUDY.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PEX_P07_PEX_CAUSE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * PCR (Possible Causal Relationship) - creates it if necessary
     */
    public PCR getPCR() { 
       PCR ret = null;
       try {
          ret = (PCR)this.get("PCR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RX_ORDER (a Group object) - creates it if necessary
     */
    public PEX_P07_RX_ORDER getRX_ORDER() { 
       PEX_P07_RX_ORDER ret = null;
       try {
          ret = (PEX_P07_RX_ORDER)this.get("RX_ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RX_ADMINISTRATION (a Group object) - creates it if necessary
     */
    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION() { 
       PEX_P07_RX_ADMINISTRATION ret = null;
       try {
          ret = (PEX_P07_RX_ADMINISTRATION)this.get("RX_ADMINISTRATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RX_ADMINISTRATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION(int rep) { 
       PEX_P07_RX_ADMINISTRATION ret = null;
       try {
          ret = (PEX_P07_RX_ADMINISTRATION)this.get("RX_ADMINISTRATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RX_ADMINISTRATION 
     */ 
    public int getRX_ADMINISTRATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RX_ADMINISTRATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RX_ADMINISTRATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRX_ADMINISTRATION(PEX_P07_RX_ADMINISTRATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("RX_ADMINISTRATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of RX_ADMINISTRATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PEX_P07_RX_ADMINISTRATION insertRX_ADMINISTRATION(int rep) throws HL7Exception { 
       return (PEX_P07_RX_ADMINISTRATION)super.insertRepetition("RX_ADMINISTRATION", rep);
    }


    /**
     * Removes a specific repetition of RX_ADMINISTRATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PEX_P07_RX_ADMINISTRATION removeRX_ADMINISTRATION(int rep) throws HL7Exception { 
       return (PEX_P07_RX_ADMINISTRATION)super.removeRepetition("RX_ADMINISTRATION", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PRB (Problem Details) - creates it if necessary
     */
    public PRB getPRB() { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PRB (Problem Details) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PRB getPRB(int rep) { 
       PRB ret = null;
       try {
          ret = (PRB)this.get("PRB", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PRB 
     */ 
    public int getPRBReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PRB").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PRB (Problem Details)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPRB(PRB structure, int rep) throws HL7Exception { 
       super.insertRepetition("PRB", structure, rep);
    }


    /**
     * Inserts a specific repetition of PRB (Problem Details)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PRB insertPRB(int rep) throws HL7Exception { 
       return (PRB)super.insertRepetition("PRB", rep);
    }


    /**
     * Removes a specific repetition of PRB (Problem Details)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PRB removePRB(int rep) throws HL7Exception { 
       return (PRB)super.removeRepetition("PRB", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * OBX (Observation/Result) - creates it if necessary
     */
    public OBX getOBX() { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * OBX (Observation/Result) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OBX getOBX(int rep) { 
       OBX ret = null;
       try {
          ret = (OBX)this.get("OBX", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of OBX 
     */ 
    public int getOBXReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("OBX").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of OBX (Observation/Result)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertOBX(OBX structure, int rep) throws HL7Exception { 
       super.insertRepetition("OBX", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBX (Observation/Result)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OBX insertOBX(int rep) throws HL7Exception { 
       return (OBX)super.insertRepetition("OBX", rep);
    }


    /**
     * Removes a specific repetition of OBX (Observation/Result)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OBX removeOBX(int rep) throws HL7Exception { 
       return (OBX)super.removeRepetition("OBX", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * ASSOCIATED_PERSON (a Group object) - creates it if necessary
     */
    public PEX_P07_ASSOCIATED_PERSON getASSOCIATED_PERSON() { 
       PEX_P07_ASSOCIATED_PERSON ret = null;
       try {
          ret = (PEX_P07_ASSOCIATED_PERSON)this.get("ASSOCIATED_PERSON");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * STUDY (a Group object) - creates it if necessary
     */
    public PEX_P07_STUDY getSTUDY() { 
       PEX_P07_STUDY ret = null;
       try {
          ret = (PEX_P07_STUDY)this.get("STUDY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * STUDY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PEX_P07_STUDY getSTUDY(int rep) { 
       PEX_P07_STUDY ret = null;
       try {
          ret = (PEX_P07_STUDY)this.get("STUDY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of STUDY 
     */ 
    public int getSTUDYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("STUDY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of STUDY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTUDY(PEX_P07_STUDY structure, int rep) throws HL7Exception { 
       super.insertRepetition("STUDY", structure, rep);
    }


    /**
     * Inserts a specific repetition of STUDY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public PEX_P07_STUDY insertSTUDY(int rep) throws HL7Exception { 
       return (PEX_P07_STUDY)super.insertRepetition("STUDY", rep);
    }


    /**
     * Removes a specific repetition of STUDY (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public PEX_P07_STUDY removeSTUDY(int rep) throws HL7Exception { 
       return (PEX_P07_STUDY)super.removeRepetition("STUDY", rep);
    }



}

