/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a VXU_V04_INSURANCE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: IN1 (Insurance) <b> </b></li>
                 * <li>2: IN2 (Insurance Additional Information) <b>optional </b></li>
                 * <li>3: IN3 (Insurance Additional Information, Certification) <b>optional </b></li>
 * </ul>
 */
public class VXU_V04_INSURANCE extends AbstractGroup {

    /** 
     * Creates a new VXU_V04_INSURANCE group
     */
    public VXU_V04_INSURANCE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(IN1.class, true, false);
                          this.add(IN2.class, false, false);
                          this.add(IN3.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXU_V04_INSURANCE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * IN1 (Insurance) - creates it if necessary
     */
    public IN1 getIN1() { 
       IN1 ret = null;
       try {
          ret = (IN1)this.get("IN1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * IN2 (Insurance Additional Information) - creates it if necessary
     */
    public IN2 getIN2() { 
       IN2 ret = null;
       try {
          ret = (IN2)this.get("IN2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * IN3 (Insurance Additional Information, Certification) - creates it if necessary
     */
    public IN3 getIN3() { 
       IN3 ret = null;
       try {
          ret = (IN3)this.get("IN3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

