/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M07_MF_CLIN_STUDY_SCHED group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: MFE (Master File Entry) <b> </b></li>
                 * <li>2: CM0 (Clinical Study Master) <b> </b></li>
                 * <li>3: CM2 (Clinical Study Schedule Master) <b>optional repeating</b></li>
 * </ul>
 */
public class MFN_M07_MF_CLIN_STUDY_SCHED extends AbstractGroup {

    /** 
     * Creates a new MFN_M07_MF_CLIN_STUDY_SCHED group
     */
    public MFN_M07_MF_CLIN_STUDY_SCHED(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MFE.class, true, false);
                          this.add(CM0.class, true, false);
                          this.add(CM2.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M07_MF_CLIN_STUDY_SCHED - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MFE (Master File Entry) - creates it if necessary
     */
    public MFE getMFE() { 
       MFE ret = null;
       try {
          ret = (MFE)this.get("MFE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * CM0 (Clinical Study Master) - creates it if necessary
     */
    public CM0 getCM0() { 
       CM0 ret = null;
       try {
          ret = (CM0)this.get("CM0");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CM2 (Clinical Study Schedule Master) - creates it if necessary
     */
    public CM2 getCM2() { 
       CM2 ret = null;
       try {
          ret = (CM2)this.get("CM2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CM2 (Clinical Study Schedule Master) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CM2 getCM2(int rep) { 
       CM2 ret = null;
       try {
          ret = (CM2)this.get("CM2", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CM2 
     */ 
    public int getCM2Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CM2").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCM2(CM2 structure, int rep) throws HL7Exception { 
       super.insertRepetition("CM2", structure, rep);
    }


    /**
     * Inserts a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CM2 insertCM2(int rep) throws HL7Exception { 
       return (CM2)super.insertRepetition("CM2", rep);
    }


    /**
     * Removes a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CM2 removeCM2(int rep) throws HL7Exception { 
       return (CM2)super.removeRepetition("CM2", rep);
    }



}

