/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a QBP_K13_ROW_DEFINITION group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RDF (Table Row Definition) <b> </b></li>
                 * <li>2: RDT (Table Row Data) <b>optional repeating</b></li>
 * </ul>
 */
public class QBP_K13_ROW_DEFINITION extends AbstractGroup {

    /** 
     * Creates a new QBP_K13_ROW_DEFINITION group
     */
    public QBP_K13_ROW_DEFINITION(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RDF.class, true, false);
                          this.add(RDT.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating QBP_K13_ROW_DEFINITION - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * RDF (Table Row Definition) - creates it if necessary
     */
    public RDF getRDF() { 
       RDF ret = null;
       try {
          ret = (RDF)this.get("RDF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RDT (Table Row Data) - creates it if necessary
     */
    public RDT getRDT() { 
       RDT ret = null;
       try {
          ret = (RDT)this.get("RDT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RDT (Table Row Data) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RDT getRDT(int rep) { 
       RDT ret = null;
       try {
          ret = (RDT)this.get("RDT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RDT 
     */ 
    public int getRDTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RDT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RDT (Table Row Data)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRDT(RDT structure, int rep) throws HL7Exception { 
       super.insertRepetition("RDT", structure, rep);
    }


    /**
     * Inserts a specific repetition of RDT (Table Row Data)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RDT insertRDT(int rep) throws HL7Exception { 
       return (RDT)super.insertRepetition("RDT", rep);
    }


    /**
     * Removes a specific repetition of RDT (Table Row Data)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RDT removeRDT(int rep) throws HL7Exception { 
       return (RDT)super.removeRepetition("RDT", rep);
    }



}

