/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.SUR_P09_FACILITY_DETAIL;
import ca.uhn.hl7v2.model.v24.group.SUR_P09_PRODUCT;
import ca.uhn.hl7v2.model.v24.segment.FAC;
import ca.uhn.hl7v2.model.v24.segment.PSH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SUR_P09_FACILITY
extends AbstractGroup {
    public SUR_P09_FACILITY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(FAC.class, true, false);
            this.add(SUR_P09_PRODUCT.class, true, true);
            this.add(PSH.class, true, false);
            this.add(SUR_P09_FACILITY_DETAIL.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SUR_P09_FACILITY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public FAC getFAC() {
        FAC ret = null;
        try {
            ret = (FAC)this.get("FAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_PRODUCT getPRODUCT() {
        SUR_P09_PRODUCT ret = null;
        try {
            ret = (SUR_P09_PRODUCT)this.get("PRODUCT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_PRODUCT getPRODUCT(int rep) {
        SUR_P09_PRODUCT ret = null;
        try {
            ret = (SUR_P09_PRODUCT)this.get("PRODUCT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRODUCTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRODUCT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRODUCT(SUR_P09_PRODUCT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT", (Structure)structure, rep);
    }

    public SUR_P09_PRODUCT insertPRODUCT(int rep) throws HL7Exception {
        return (SUR_P09_PRODUCT)super.insertRepetition("PRODUCT", rep);
    }

    public SUR_P09_PRODUCT removePRODUCT(int rep) throws HL7Exception {
        return (SUR_P09_PRODUCT)super.removeRepetition("PRODUCT", rep);
    }

    public PSH getPSH() {
        PSH ret = null;
        try {
            ret = (PSH)this.get("PSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_FACILITY_DETAIL getFACILITY_DETAIL() {
        SUR_P09_FACILITY_DETAIL ret = null;
        try {
            ret = (SUR_P09_FACILITY_DETAIL)this.get("FACILITY_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SUR_P09_FACILITY_DETAIL getFACILITY_DETAIL(int rep) {
        SUR_P09_FACILITY_DETAIL ret = null;
        try {
            ret = (SUR_P09_FACILITY_DETAIL)this.get("FACILITY_DETAIL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFACILITY_DETAILReps() {
        int reps = -1;
        try {
            reps = this.getAll("FACILITY_DETAIL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFACILITY_DETAIL(SUR_P09_FACILITY_DETAIL structure, int rep) throws HL7Exception {
        super.insertRepetition("FACILITY_DETAIL", (Structure)structure, rep);
    }

    public SUR_P09_FACILITY_DETAIL insertFACILITY_DETAIL(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY_DETAIL)super.insertRepetition("FACILITY_DETAIL", rep);
    }

    public SUR_P09_FACILITY_DETAIL removeFACILITY_DETAIL(int rep) throws HL7Exception {
        return (SUR_P09_FACILITY_DETAIL)super.removeRepetition("FACILITY_DETAIL", rep);
    }
}

