/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_COMPONENT;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_OBSERVATION;
import ca.uhn.hl7v2.model.v24.segment.BLG;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXO;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMP_O09_ORDER
extends AbstractGroup {
    public OMP_O09_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RXO.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RXR.class, true, true);
            this.add(OMP_O09_COMPONENT.class, false, false);
            this.add(OMP_O09_OBSERVATION.class, false, true);
            this.add(FT1.class, false, true);
            this.add(BLG.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OMP_O09_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXO getRXO() {
        RXO ret = null;
        try {
            ret = (RXO)this.get("RXO");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR(int rep) {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public OMP_O09_COMPONENT getCOMPONENT() {
        OMP_O09_COMPONENT ret = null;
        try {
            ret = (OMP_O09_COMPONENT)this.get("COMPONENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMP_O09_OBSERVATION getOBSERVATION() {
        OMP_O09_OBSERVATION ret = null;
        try {
            ret = (OMP_O09_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMP_O09_OBSERVATION getOBSERVATION(int rep) {
        OMP_O09_OBSERVATION ret = null;
        try {
            ret = (OMP_O09_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OMP_O09_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OMP_O09_OBSERVATION.class);
    }

    public void insertOBSERVATION(OMP_O09_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OMP_O09_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OMP_O09_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OMP_O09_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OMP_O09_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FT1 getFT1(int rep) {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("FT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public BLG getBLG() {
        BLG ret = null;
        try {
            ret = (BLG)this.get("BLG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

