/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.ORL_O22_GENERAL_ORDER;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O22_PATIENT
extends AbstractGroup {
    public ORL_O22_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(ORL_O22_GENERAL_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORL_O22_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O22_GENERAL_ORDER getGENERAL_ORDER() {
        ORL_O22_GENERAL_ORDER ret = null;
        try {
            ret = (ORL_O22_GENERAL_ORDER)this.get("GENERAL_ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O22_GENERAL_ORDER getGENERAL_ORDER(int rep) {
        ORL_O22_GENERAL_ORDER ret = null;
        try {
            ret = (ORL_O22_GENERAL_ORDER)this.get("GENERAL_ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGENERAL_ORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("GENERAL_ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORL_O22_GENERAL_ORDER> getGENERAL_ORDERAll() throws HL7Exception {
        return this.getAllAsList("GENERAL_ORDER", ORL_O22_GENERAL_ORDER.class);
    }

    public void insertGENERAL_ORDER(ORL_O22_GENERAL_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("GENERAL_ORDER", (Structure)structure, rep);
    }

    public ORL_O22_GENERAL_ORDER insertGENERAL_ORDER(int rep) throws HL7Exception {
        return (ORL_O22_GENERAL_ORDER)super.insertRepetition("GENERAL_ORDER", rep);
    }

    public ORL_O22_GENERAL_ORDER removeGENERAL_ORDER(int rep) throws HL7Exception {
        return (ORL_O22_GENERAL_ORDER)super.removeRepetition("GENERAL_ORDER", rep);
    }
}

