/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_PEX_OBSERVATION;
import ca.uhn.hl7v2.model.v24.segment.PES;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEX_P07_EXPERIENCE
extends AbstractGroup {
    public PEX_P07_EXPERIENCE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PES.class, true, false);
            this.add(PEX_P07_PEX_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PEX_P07_EXPERIENCE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PES getPES() {
        PES ret = null;
        try {
            ret = (PES)this.get("PES");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_PEX_OBSERVATION getPEX_OBSERVATION() {
        PEX_P07_PEX_OBSERVATION ret = null;
        try {
            ret = (PEX_P07_PEX_OBSERVATION)this.get("PEX_OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_PEX_OBSERVATION getPEX_OBSERVATION(int rep) {
        PEX_P07_PEX_OBSERVATION ret = null;
        try {
            ret = (PEX_P07_PEX_OBSERVATION)this.get("PEX_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPEX_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("PEX_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PEX_P07_PEX_OBSERVATION> getPEX_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PEX_OBSERVATION", PEX_P07_PEX_OBSERVATION.class);
    }

    public void insertPEX_OBSERVATION(PEX_P07_PEX_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PEX_OBSERVATION", (Structure)structure, rep);
    }

    public PEX_P07_PEX_OBSERVATION insertPEX_OBSERVATION(int rep) throws HL7Exception {
        return (PEX_P07_PEX_OBSERVATION)super.insertRepetition("PEX_OBSERVATION", rep);
    }

    public PEX_P07_PEX_OBSERVATION removePEX_OBSERVATION(int rep) throws HL7Exception {
        return (PEX_P07_PEX_OBSERVATION)super.removeRepetition("PEX_OBSERVATION", rep);
    }
}

