/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.ADT_A03_PROCEDURE;
import ca.uhn.hl7v2.model.v24.segment.DB1;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.DRG;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.PD1;
import ca.uhn.hl7v2.model.v24.segment.PDA;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.PV1;
import ca.uhn.hl7v2.model.v24.segment.PV2;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A03
extends AbstractMessage {
    public ADT_A03() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ROL.class, false, true);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(ROL.class, false, true);
            this.add(DB1.class, false, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(ADT_A03_PROCEDURE.class, false, true);
            this.add(OBX.class, false, true);
            this.add(PDA.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ADT_A03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROLReps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public PV1 getPV1() {
        PV1 ret = null;
        try {
            ret = (PV1)this.get("PV1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV2 getPV2() {
        PV2 ret = null;
        try {
            ret = (PV2)this.get("PV2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL2() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL2(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL2", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROL2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", (Structure)structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB1(int rep) {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDB1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DB1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG ret = null;
        try {
            ret = (DRG)this.get("DRG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A03_PROCEDURE getPROCEDURE() {
        ADT_A03_PROCEDURE ret = null;
        try {
            ret = (ADT_A03_PROCEDURE)this.get("PROCEDURE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A03_PROCEDURE getPROCEDURE(int rep) {
        ADT_A03_PROCEDURE ret = null;
        try {
            ret = (ADT_A03_PROCEDURE)this.get("PROCEDURE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROCEDUREReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROCEDURE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ADT_A03_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADT_A03_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADT_A03_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public ADT_A03_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADT_A03_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public ADT_A03_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADT_A03_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public PDA getPDA() {
        PDA ret = null;
        try {
            ret = (PDA)this.get("PDA");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

