/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.OML_O21_ORDER_GENERAL;
import ca.uhn.hl7v2.model.v24.group.OML_O21_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OML_O21
extends AbstractMessage {
    public OML_O21() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OML_O21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OML_O21_PATIENT.class, false, false);
            this.add(OML_O21_ORDER_GENERAL.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OML_O21 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OML_O21_PATIENT getPATIENT() {
        OML_O21_PATIENT ret = null;
        try {
            ret = (OML_O21_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_ORDER_GENERAL getORDER_GENERAL() {
        OML_O21_ORDER_GENERAL ret = null;
        try {
            ret = (OML_O21_ORDER_GENERAL)this.get("ORDER_GENERAL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_ORDER_GENERAL getORDER_GENERAL(int rep) {
        OML_O21_ORDER_GENERAL ret = null;
        try {
            ret = (OML_O21_ORDER_GENERAL)this.get("ORDER_GENERAL", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_GENERALReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_GENERAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OML_O21_ORDER_GENERAL> getORDER_GENERALAll() throws HL7Exception {
        return this.getAllAsList("ORDER_GENERAL", OML_O21_ORDER_GENERAL.class);
    }

    public void insertORDER_GENERAL(OML_O21_ORDER_GENERAL structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_GENERAL", (Structure)structure, rep);
    }

    public OML_O21_ORDER_GENERAL insertORDER_GENERAL(int rep) throws HL7Exception {
        return (OML_O21_ORDER_GENERAL)super.insertRepetition("ORDER_GENERAL", rep);
    }

    public OML_O21_ORDER_GENERAL removeORDER_GENERAL(int rep) throws HL7Exception {
        return (OML_O21_ORDER_GENERAL)super.removeRepetition("ORDER_GENERAL", rep);
    }
}

