/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.PPP_PCB_PATHWAY;
import ca.uhn.hl7v2.model.v24.group.PPP_PCB_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPP_PCB
extends AbstractMessage {
    public PPP_PCB() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPP_PCB(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PPP_PCB_PATIENT_VISIT.class, false, false);
            this.add(PPP_PCB_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PPP_PCB - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPP_PCB_PATIENT_VISIT getPATIENT_VISIT() {
        PPP_PCB_PATIENT_VISIT ret = null;
        try {
            ret = (PPP_PCB_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPP_PCB_PATHWAY getPATHWAY() {
        PPP_PCB_PATHWAY ret = null;
        try {
            ret = (PPP_PCB_PATHWAY)this.get("PATHWAY");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPP_PCB_PATHWAY getPATHWAY(int rep) {
        PPP_PCB_PATHWAY ret = null;
        try {
            ret = (PPP_PCB_PATHWAY)this.get("PATHWAY", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PPP_PCB_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPP_PCB_PATHWAY.class);
    }

    public void insertPATHWAY(PPP_PCB_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPP_PCB_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPP_PCB_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

