/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CF (Coded Element with Formatted Values) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Identifier (ST)
 * <li>Formatted Text (FT)
 * <li>Name of Coding System (ID)
 * <li>Alternate Identifier (ST)
 * <li>Alternate Formatted Text (FT)
 * <li>Name of Alternate Coding System (ID)
 * </ul>
 */
public class CF extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CF type
     */
    public CF(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new ST(getMessage());
        data[1] = new FT(getMessage());
        data[2] = new ID(getMessage(), 396);
        data[3] = new ST(getMessage());
        data[4] = new FT(getMessage());
        data[5] = new ID(getMessage(), 396);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCf1_Identifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Formatted Text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Formatted Text (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getCf2_FormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name of Coding System (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameOfCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name of Coding System (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCf3_NameOfCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Alternate Identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAlternateIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Alternate Identifier (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCf4_AlternateIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Alternate Formatted Text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getAlternateFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Alternate Formatted Text (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FT getCf5_AlternateFormattedText() {
       FT ret = null;
       try {
          ret = (FT)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name of Alternate Coding System (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameOfAlternateCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name of Alternate Coding System (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCf6_NameOfAlternateCodingSystem() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

