/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 RPT (Repeat Pattern) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Repeat Pattern Code (CWE)
 * <li>Calendar Alignment (ID)
 * <li>Phase Range Begin Value (NM)
 * <li>Phase Range End Value (NM)
 * <li>Period Quantity (NM)
 * <li>Period Units (IS)
 * <li>Institution Specified Time (ID)
 * <li>Event (ID)
 * <li>Event Offset Quantity (NM)
 * <li>Event Offset Units (IS)
 * <li>General Timing Specification (GTS)
 * </ul>
 */
public class RPT extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new RPT type
     */
    public RPT(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[11];    
        data[0] = new CWE(getMessage());
        data[1] = new ID(getMessage(), 527);
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new IS(getMessage(), 0);
        data[6] = new ID(getMessage(), 136);
        data[7] = new ID(getMessage(), 528);
        data[8] = new NM(getMessage());
        data[9] = new IS(getMessage(), 0);
        data[10] = new GTS(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Repeat Pattern Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getRepeatPatternCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Repeat Pattern Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getRpt1_RepeatPatternCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Calendar Alignment (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCalendarAlignment() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Calendar Alignment (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRpt2_CalendarAlignment() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Phase Range Begin Value (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getPhaseRangeBeginValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Phase Range Begin Value (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getRpt3_PhaseRangeBeginValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Phase Range End Value (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getPhaseRangeEndValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Phase Range End Value (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getRpt4_PhaseRangeEndValue() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Period Quantity (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getPeriodQuantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Period Quantity (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getRpt5_PeriodQuantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Period Units (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPeriodUnits() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Period Units (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRpt6_PeriodUnits() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Institution Specified Time (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getInstitutionSpecifiedTime() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Institution Specified Time (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRpt7_InstitutionSpecifiedTime() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Event (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEvent() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Event (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRpt8_Event() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Event Offset Quantity (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getEventOffsetQuantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Event Offset Quantity (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getRpt9_EventOffsetQuantity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Event Offset Units (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getEventOffsetUnits() {
       IS ret = null;
       try {
          ret = (IS)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Event Offset Units (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRpt10_EventOffsetUnits() {
       IS ret = null;
       try {
          ret = (IS)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns General Timing Specification (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public GTS getGeneralTimingSpecification() {
       GTS ret = null;
       try {
          ret = (GTS)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns General Timing Specification (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public GTS getRpt11_GeneralTimingSpecification() {
       GTS ret = null;
       try {
          ret = (GTS)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

