/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a DFT_P11_COMMON_ORDER group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b>optional </b></li>
                 * <li>2: DFT_P11_TIMING_QUANTITY (a Group object) <b>optional repeating</b></li>
                 * <li>3: DFT_P11_ORDER (a Group object) <b>optional </b></li>
                 * <li>4: DFT_P11_OBSERVATION (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class DFT_P11_COMMON_ORDER extends AbstractGroup {

    /** 
     * Creates a new DFT_P11_COMMON_ORDER group
     */
    public DFT_P11_COMMON_ORDER(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, false, false);
                          this.add(DFT_P11_TIMING_QUANTITY.class, false, true);
                          this.add(DFT_P11_ORDER.class, false, false);
                          this.add(DFT_P11_OBSERVATION.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P11_COMMON_ORDER - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TIMING_QUANTITY (a Group object) - creates it if necessary
     */
    public DFT_P11_TIMING_QUANTITY getTIMING_QUANTITY() { 
       DFT_P11_TIMING_QUANTITY ret = null;
       try {
          ret = (DFT_P11_TIMING_QUANTITY)this.get("TIMING_QUANTITY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TIMING_QUANTITY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P11_TIMING_QUANTITY getTIMING_QUANTITY(int rep) { 
       DFT_P11_TIMING_QUANTITY ret = null;
       try {
          ret = (DFT_P11_TIMING_QUANTITY)this.get("TIMING_QUANTITY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TIMING_QUANTITY 
     */ 
    public int getTIMING_QUANTITYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TIMING_QUANTITY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TIMING_QUANTITY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertTIMING_QUANTITY(DFT_P11_TIMING_QUANTITY structure, int rep) throws HL7Exception { 
       super.insertRepetition("TIMING_QUANTITY", structure, rep);
    }


    /**
     * Inserts a specific repetition of TIMING_QUANTITY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P11_TIMING_QUANTITY insertTIMING_QUANTITY(int rep) throws HL7Exception { 
       return (DFT_P11_TIMING_QUANTITY)super.insertRepetition("TIMING_QUANTITY", rep);
    }


    /**
     * Removes a specific repetition of TIMING_QUANTITY (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P11_TIMING_QUANTITY removeTIMING_QUANTITY(int rep) throws HL7Exception { 
       return (DFT_P11_TIMING_QUANTITY)super.removeRepetition("TIMING_QUANTITY", rep);
    }



    /**
     * Returns
     * ORDER (a Group object) - creates it if necessary
     */
    public DFT_P11_ORDER getORDER() { 
       DFT_P11_ORDER ret = null;
       try {
          ret = (DFT_P11_ORDER)this.get("ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * OBSERVATION (a Group object) - creates it if necessary
     */
    public DFT_P11_OBSERVATION getOBSERVATION() { 
       DFT_P11_OBSERVATION ret = null;
       try {
          ret = (DFT_P11_OBSERVATION)this.get("OBSERVATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * OBSERVATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P11_OBSERVATION getOBSERVATION(int rep) { 
       DFT_P11_OBSERVATION ret = null;
       try {
          ret = (DFT_P11_OBSERVATION)this.get("OBSERVATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of OBSERVATION 
     */ 
    public int getOBSERVATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("OBSERVATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertOBSERVATION(DFT_P11_OBSERVATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("OBSERVATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P11_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception { 
       return (DFT_P11_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }


    /**
     * Removes a specific repetition of OBSERVATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P11_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception { 
       return (DFT_P11_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }



}

