/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a EAR_U08 message structure (see chapter 13.3.8). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: SFT (Software Segment) <b>optional repeating</b></li>
                 * <li>3: EQU (Equipment Detail) <b> </b></li>
                 * <li>4: EAR_U08_COMMAND_RESPONSE (a Group object) <b> repeating</b></li>
                 * <li>5: ROL (Role) <b>optional </b></li>
 * </ul>
 */
public class EAR_U08 extends AbstractMessage  {

    /** 
     * Creates a new EAR_U08 message with custom ModelClassFactory.
     */
    public EAR_U08(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new EAR_U08 message with DefaultModelClassFactory. 
     */ 
    public EAR_U08() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(SFT.class, false, true);
                          this.add(EQU.class, true, false);
                          this.add(EAR_U08_COMMAND_RESPONSE.class, true, true);
                          this.add(ROL.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EAR_U08 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SFT (Software Segment) - creates it if necessary
     */
    public SFT getSFT() { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SFT (Software Segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SFT getSFT(int rep) { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SFT 
     */ 
    public int getSFTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SFT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSFT(SFT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SFT", structure, rep);
    }


    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SFT insertSFT(int rep) throws HL7Exception { 
       return (SFT)super.insertRepetition("SFT", rep);
    }


    /**
     * Removes a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SFT removeSFT(int rep) throws HL7Exception { 
       return (SFT)super.removeRepetition("SFT", rep);
    }



    /**
     * Returns
     * EQU (Equipment Detail) - creates it if necessary
     */
    public EQU getEQU() { 
       EQU ret = null;
       try {
          ret = (EQU)this.get("EQU");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * COMMAND_RESPONSE (a Group object) - creates it if necessary
     */
    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE() { 
       EAR_U08_COMMAND_RESPONSE ret = null;
       try {
          ret = (EAR_U08_COMMAND_RESPONSE)this.get("COMMAND_RESPONSE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * COMMAND_RESPONSE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE(int rep) { 
       EAR_U08_COMMAND_RESPONSE ret = null;
       try {
          ret = (EAR_U08_COMMAND_RESPONSE)this.get("COMMAND_RESPONSE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of COMMAND_RESPONSE 
     */ 
    public int getCOMMAND_RESPONSEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("COMMAND_RESPONSE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of COMMAND_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertCOMMAND_RESPONSE(EAR_U08_COMMAND_RESPONSE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "COMMAND_RESPONSE", structure, rep);
    }


    /**
     * Inserts a specific repetition of COMMAND_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public EAR_U08_COMMAND_RESPONSE insertCOMMAND_RESPONSE(int rep) throws HL7Exception { 
       return (EAR_U08_COMMAND_RESPONSE)super.insertRepetition("COMMAND_RESPONSE", rep);
    }


    /**
     * Removes a specific repetition of COMMAND_RESPONSE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public EAR_U08_COMMAND_RESPONSE removeCOMMAND_RESPONSE(int rep) throws HL7Exception { 
       return (EAR_U08_COMMAND_RESPONSE)super.removeRepetition("COMMAND_RESPONSE", rep);
    }



    /**
     * Returns
     * ROL (Role) - creates it if necessary
     */
    public ROL getROL() { 
       ROL ret = null;
       try {
          ret = (ROL)this.get("ROL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

